/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingClientImpl;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.PriceChangeConfirmationListener;
import com.android.billingclient.api.PriceChangeFlowParams;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.android.billingclient.api.zze;
import com.android.billingclient.api.zzi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class BillingClient {
    @AnyThread
    public abstract int getConnectionState();

    @AnyThread
    @NonNull
    public static Builder newBuilder(@NonNull Context context) {
        Context context2;
        Builder builder = new Builder(context2, null);
        return builder;
    }

    @AnyThread
    @NonNull
    public abstract BillingResult isFeatureSupported(@NonNull String var1);

    @UiThread
    @NonNull
    public abstract BillingResult launchBillingFlow(@NonNull Activity var1, @NonNull BillingFlowParams var2);

    @Deprecated
    @NonNull
    public abstract Purchase.PurchasesResult queryPurchases(@NonNull String var1);

    @AnyThread
    public abstract void acknowledgePurchase(@NonNull AcknowledgePurchaseParams var1, @NonNull AcknowledgePurchaseResponseListener var2);

    @AnyThread
    public abstract void consumeAsync(@NonNull ConsumeParams var1, @NonNull ConsumeResponseListener var2);

    @AnyThread
    public abstract void endConnection();

    @UiThread
    public abstract void launchPriceChangeConfirmationFlow(@NonNull Activity var1, @NonNull PriceChangeFlowParams var2, @NonNull PriceChangeConfirmationListener var3);

    @AnyThread
    public abstract void queryPurchaseHistoryAsync(@NonNull String var1, @NonNull PurchaseHistoryResponseListener var2);

    @zze
    @AnyThread
    public abstract void queryPurchasesAsync(@NonNull String var1, @NonNull PurchasesResponseListener var2);

    @AnyThread
    public abstract void querySkuDetailsAsync(@NonNull SkuDetailsParams var1, @NonNull SkuDetailsResponseListener var2);

    @AnyThread
    public abstract void startConnection(@NonNull BillingClientStateListener var1);

    @AnyThread
    public abstract boolean isReady();

    @AnyThread
    public static final class Builder {
        private volatile String zza;
        private volatile boolean zzb;
        private final Context zzc;
        private volatile PurchasesUpdatedListener zzd;

        @NonNull
        public Builder enablePendingPurchases() {
            this.zzb = true;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setListener(@NonNull PurchasesUpdatedListener listener) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        @NonNull
        public BillingClient build() {
            Object this_;
            if (((Builder)this_).zzc == null) {
                this_ = new IllegalArgumentException("Please provide a valid Context.");
                throw this_;
            }
            if (((Builder)this_).zzd == null) {
                this_ = new IllegalArgumentException("Please provide a valid listener for purchases updates.");
                throw this_;
            }
            if (!((Builder)this_).zzb) {
                this_ = new IllegalArgumentException("Support for pending purchases must be enabled. Enable this by calling 'enablePendingPurchases()' on BillingClientBuilder.");
                throw this_;
            }
            BillingClientImpl billingClientImpl = new BillingClientImpl(null, ((Builder)this_).zzb, ((Builder)this_).zzc, ((Builder)this_).zzd);
            return billingClientImpl;
        }

        /* synthetic */ Builder(Context context, zzi zzi2) {
            this.zzc = context;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionState {
        public static final int DISCONNECTED = 0;
        public static final int CONNECTING = 1;
        public static final int CONNECTED = 2;
        public static final int CLOSED = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BillingResponseCode {
        public static final int SERVICE_TIMEOUT = -3;
        public static final int FEATURE_NOT_SUPPORTED = -2;
        public static final int SERVICE_DISCONNECTED = -1;
        public static final int OK = 0;
        public static final int USER_CANCELED = 1;
        public static final int SERVICE_UNAVAILABLE = 2;
        public static final int BILLING_UNAVAILABLE = 3;
        public static final int ITEM_UNAVAILABLE = 4;
        public static final int DEVELOPER_ERROR = 5;
        public static final int ERROR = 6;
        public static final int ITEM_ALREADY_OWNED = 7;
        public static final int ITEM_NOT_OWNED = 8;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureType {
        @NonNull
        public static final String SUBSCRIPTIONS = "subscriptions";
        @NonNull
        public static final String SUBSCRIPTIONS_UPDATE = "subscriptionsUpdate";
        @NonNull
        public static final String IN_APP_ITEMS_ON_VR = "inAppItemsOnVr";
        @NonNull
        public static final String SUBSCRIPTIONS_ON_VR = "subscriptionsOnVr";
        @NonNull
        public static final String PRICE_CHANGE_CONFIRMATION = "priceChangeConfirmation";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SkuType {
        @NonNull
        public static final String INAPP = "inapp";
        @NonNull
        public static final String SUBS = "subs";
    }
}

