/****************************************************************************
**
** Copyright (C) 2013 Klaralvdalens Datakonsult AB (KDAB)
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtOpenGL module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
**
** This file was generated by glgen version 0.1
** Command line was: glgen
**
** glgen is Copyright (C) 2013 Klaralvdalens Datakonsult AB (KDAB)
**
** This is an auto-generated file.
** Do not edit! All changes made to it will be lost.
**
****************************************************************************/

#ifndef QOPENGLVERSIONFUNCTIONS_1_5_H
#define QOPENGLVERSIONFUNCTIONS_1_5_H

#include <QtOpenGL/qtopenglglobal.h>

#if !defined(QT_NO_OPENGL) && !QT_CONFIG(opengles2)

#include <QtOpenGL/QOpenGLVersionProfile>
#include <QtOpenGL/QOpenGLVersionFunctions>
#include <QtGui/qopenglcontext.h>

QT_BEGIN_NAMESPACE

class Q_OPENGL_EXPORT QOpenGLFunctions_1_5 : public QAbstractOpenGLFunctions
{
public:
    QOpenGLFunctions_1_5();
    ~QOpenGLFunctions_1_5();

    bool initializeOpenGLFunctions() override;

    // OpenGL 1.0 core functions
    void glViewport(GLint x, GLint y, GLsizei width, GLsizei height);
    void glDepthRange(GLdouble nearVal, GLdouble farVal);
    GLboolean glIsEnabled(GLenum cap);
    void glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params);
    void glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat *params);
    void glGetTexParameteriv(GLenum target, GLenum pname, GLint *params);
    void glGetTexParameterfv(GLenum target, GLenum pname, GLfloat *params);
    void glGetTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
    const GLubyte * glGetString(GLenum name);
    void glGetIntegerv(GLenum pname, GLint *params);
    void glGetFloatv(GLenum pname, GLfloat *params);
    GLenum glGetError();
    void glGetDoublev(GLenum pname, GLdouble *params);
    void glGetBooleanv(GLenum pname, GLboolean *params);
    void glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
    void glReadBuffer(GLenum mode);
    void glPixelStorei(GLenum pname, GLint param);
    void glPixelStoref(GLenum pname, GLfloat param);
    void glDepthFunc(GLenum func);
    void glStencilOp(GLenum fail, GLenum zfail, GLenum zpass);
    void glStencilFunc(GLenum func, GLint ref, GLuint mask);
    void glLogicOp(GLenum opcode);
    void glBlendFunc(GLenum sfactor, GLenum dfactor);
    void glFlush();
    void glFinish();
    void glEnable(GLenum cap);
    void glDisable(GLenum cap);
    void glDepthMask(GLboolean flag);
    void glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
    void glStencilMask(GLuint mask);
    void glClearDepth(GLdouble depth);
    void glClearStencil(GLint s);
    void glClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
    void glClear(GLbitfield mask);
    void glDrawBuffer(GLenum mode);
    void glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void glTexImage1D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void glTexParameteriv(GLenum target, GLenum pname, const GLint *params);
    void glTexParameteri(GLenum target, GLenum pname, GLint param);
    void glTexParameterfv(GLenum target, GLenum pname, const GLfloat *params);
    void glTexParameterf(GLenum target, GLenum pname, GLfloat param);
    void glScissor(GLint x, GLint y, GLsizei width, GLsizei height);
    void glPolygonMode(GLenum face, GLenum mode);
    void glPointSize(GLfloat size);
    void glLineWidth(GLfloat width);
    void glHint(GLenum target, GLenum mode);
    void glFrontFace(GLenum mode);
    void glCullFace(GLenum mode);

    // OpenGL 1.1 core functions
    void glIndexubv(const GLubyte *c);
    void glIndexub(GLubyte c);
    GLboolean glIsTexture(GLuint texture);
    void glGenTextures(GLsizei n, GLuint *textures);
    void glDeleteTextures(GLsizei n, const GLuint *textures);
    void glBindTexture(GLenum target, GLuint texture);
    void glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
    void glTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
    void glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void glCopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
    void glCopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
    void glCopyTexImage1D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
    void glPolygonOffset(GLfloat factor, GLfloat units);
    void glGetPointerv(GLenum pname, GLvoid* *params);
    void glDrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
    void glDrawArrays(GLenum mode, GLint first, GLsizei count);

    // OpenGL 1.2 core functions
    void glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
    void glTexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);
    void glBlendEquation(GLenum mode);
    void glBlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);

    // OpenGL 1.3 core functions
    void glGetCompressedTexImage(GLenum target, GLint level, GLvoid *img);
    void glCompressedTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexImage1D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
    void glSampleCoverage(GLfloat value, GLboolean invert);
    void glActiveTexture(GLenum texture);

    // OpenGL 1.4 core functions
    void glPointParameteriv(GLenum pname, const GLint *params);
    void glPointParameteri(GLenum pname, GLint param);
    void glPointParameterfv(GLenum pname, const GLfloat *params);
    void glPointParameterf(GLenum pname, GLfloat param);
    void glMultiDrawElements(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount);
    void glMultiDrawArrays(GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount);
    void glBlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);

    // OpenGL 1.5 core functions
    void glGetBufferPointerv(GLenum target, GLenum pname, GLvoid* *params);
    void glGetBufferParameteriv(GLenum target, GLenum pname, GLint *params);
    GLboolean glUnmapBuffer(GLenum target);
    GLvoid* glMapBuffer(GLenum target, GLenum access);
    void glGetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid *data);
    void glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid *data);
    void glBufferData(GLenum target, GLsizeiptr size, const GLvoid *data, GLenum usage);
    GLboolean glIsBuffer(GLuint buffer);
    void glGenBuffers(GLsizei n, GLuint *buffers);
    void glDeleteBuffers(GLsizei n, const GLuint *buffers);
    void glBindBuffer(GLenum target, GLuint buffer);
    void glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint *params);
    void glGetQueryObjectiv(GLuint id, GLenum pname, GLint *params);
    void glGetQueryiv(GLenum target, GLenum pname, GLint *params);
    void glEndQuery(GLenum target);
    void glBeginQuery(GLenum target, GLuint id);
    GLboolean glIsQuery(GLuint id);
    void glDeleteQueries(GLsizei n, const GLuint *ids);
    void glGenQueries(GLsizei n, GLuint *ids);

    // OpenGL 1.0 deprecated functions
    void glTranslatef(GLfloat x, GLfloat y, GLfloat z);
    void glTranslated(GLdouble x, GLdouble y, GLdouble z);
    void glScalef(GLfloat x, GLfloat y, GLfloat z);
    void glScaled(GLdouble x, GLdouble y, GLdouble z);
    void glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
    void glRotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
    void glPushMatrix();
    void glPopMatrix();
    void glOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
    void glMultMatrixd(const GLdouble *m);
    void glMultMatrixf(const GLfloat *m);
    void glMatrixMode(GLenum mode);
    void glLoadMatrixd(const GLdouble *m);
    void glLoadMatrixf(const GLfloat *m);
    void glLoadIdentity();
    void glFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
    GLboolean glIsList(GLuint list);
    void glGetTexGeniv(GLenum coord, GLenum pname, GLint *params);
    void glGetTexGenfv(GLenum coord, GLenum pname, GLfloat *params);
    void glGetTexGendv(GLenum coord, GLenum pname, GLdouble *params);
    void glGetTexEnviv(GLenum target, GLenum pname, GLint *params);
    void glGetTexEnvfv(GLenum target, GLenum pname, GLfloat *params);
    void glGetPolygonStipple(GLubyte *mask);
    void glGetPixelMapusv(GLenum map, GLushort *values);
    void glGetPixelMapuiv(GLenum map, GLuint *values);
    void glGetPixelMapfv(GLenum map, GLfloat *values);
    void glGetMaterialiv(GLenum face, GLenum pname, GLint *params);
    void glGetMaterialfv(GLenum face, GLenum pname, GLfloat *params);
    void glGetMapiv(GLenum target, GLenum query, GLint *v);
    void glGetMapfv(GLenum target, GLenum query, GLfloat *v);
    void glGetMapdv(GLenum target, GLenum query, GLdouble *v);
    void glGetLightiv(GLenum light, GLenum pname, GLint *params);
    void glGetLightfv(GLenum light, GLenum pname, GLfloat *params);
    void glGetClipPlane(GLenum plane, GLdouble *equation);
    void glDrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
    void glCopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
    void glPixelMapusv(GLenum map, GLint mapsize, const GLushort *values);
    void glPixelMapuiv(GLenum map, GLint mapsize, const GLuint *values);
    void glPixelMapfv(GLenum map, GLint mapsize, const GLfloat *values);
    void glPixelTransferi(GLenum pname, GLint param);
    void glPixelTransferf(GLenum pname, GLfloat param);
    void glPixelZoom(GLfloat xfactor, GLfloat yfactor);
    void glAlphaFunc(GLenum func, GLfloat ref);
    void glEvalPoint2(GLint i, GLint j);
    void glEvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
    void glEvalPoint1(GLint i);
    void glEvalMesh1(GLenum mode, GLint i1, GLint i2);
    void glEvalCoord2fv(const GLfloat *u);
    void glEvalCoord2f(GLfloat u, GLfloat v);
    void glEvalCoord2dv(const GLdouble *u);
    void glEvalCoord2d(GLdouble u, GLdouble v);
    void glEvalCoord1fv(const GLfloat *u);
    void glEvalCoord1f(GLfloat u);
    void glEvalCoord1dv(const GLdouble *u);
    void glEvalCoord1d(GLdouble u);
    void glMapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
    void glMapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
    void glMapGrid1f(GLint un, GLfloat u1, GLfloat u2);
    void glMapGrid1d(GLint un, GLdouble u1, GLdouble u2);
    void glMap2f(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
    void glMap2d(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
    void glMap1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
    void glMap1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
    void glPushAttrib(GLbitfield mask);
    void glPopAttrib();
    void glAccum(GLenum op, GLfloat value);
    void glIndexMask(GLuint mask);
    void glClearIndex(GLfloat c);
    void glClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
    void glPushName(GLuint name);
    void glPopName();
    void glPassThrough(GLfloat token);
    void glLoadName(GLuint name);
    void glInitNames();
    GLint glRenderMode(GLenum mode);
    void glSelectBuffer(GLsizei size, GLuint *buffer);
    void glFeedbackBuffer(GLsizei size, GLenum type, GLfloat *buffer);
    void glTexGeniv(GLenum coord, GLenum pname, const GLint *params);
    void glTexGeni(GLenum coord, GLenum pname, GLint param);
    void glTexGenfv(GLenum coord, GLenum pname, const GLfloat *params);
    void glTexGenf(GLenum coord, GLenum pname, GLfloat param);
    void glTexGendv(GLenum coord, GLenum pname, const GLdouble *params);
    void glTexGend(GLenum coord, GLenum pname, GLdouble param);
    void glTexEnviv(GLenum target, GLenum pname, const GLint *params);
    void glTexEnvi(GLenum target, GLenum pname, GLint param);
    void glTexEnvfv(GLenum target, GLenum pname, const GLfloat *params);
    void glTexEnvf(GLenum target, GLenum pname, GLfloat param);
    void glShadeModel(GLenum mode);
    void glPolygonStipple(const GLubyte *mask);
    void glMaterialiv(GLenum face, GLenum pname, const GLint *params);
    void glMateriali(GLenum face, GLenum pname, GLint param);
    void glMaterialfv(GLenum face, GLenum pname, const GLfloat *params);
    void glMaterialf(GLenum face, GLenum pname, GLfloat param);
    void glLineStipple(GLint factor, GLushort pattern);
    void glLightModeliv(GLenum pname, const GLint *params);
    void glLightModeli(GLenum pname, GLint param);
    void glLightModelfv(GLenum pname, const GLfloat *params);
    void glLightModelf(GLenum pname, GLfloat param);
    void glLightiv(GLenum light, GLenum pname, const GLint *params);
    void glLighti(GLenum light, GLenum pname, GLint param);
    void glLightfv(GLenum light, GLenum pname, const GLfloat *params);
    void glLightf(GLenum light, GLenum pname, GLfloat param);
    void glFogiv(GLenum pname, const GLint *params);
    void glFogi(GLenum pname, GLint param);
    void glFogfv(GLenum pname, const GLfloat *params);
    void glFogf(GLenum pname, GLfloat param);
    void glColorMaterial(GLenum face, GLenum mode);
    void glClipPlane(GLenum plane, const GLdouble *equation);
    void glVertex4sv(const GLshort *v);
    void glVertex4s(GLshort x, GLshort y, GLshort z, GLshort w);
    void glVertex4iv(const GLint *v);
    void glVertex4i(GLint x, GLint y, GLint z, GLint w);
    void glVertex4fv(const GLfloat *v);
    void glVertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glVertex4dv(const GLdouble *v);
    void glVertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glVertex3sv(const GLshort *v);
    void glVertex3s(GLshort x, GLshort y, GLshort z);
    void glVertex3iv(const GLint *v);
    void glVertex3i(GLint x, GLint y, GLint z);
    void glVertex3fv(const GLfloat *v);
    void glVertex3f(GLfloat x, GLfloat y, GLfloat z);
    void glVertex3dv(const GLdouble *v);
    void glVertex3d(GLdouble x, GLdouble y, GLdouble z);
    void glVertex2sv(const GLshort *v);
    void glVertex2s(GLshort x, GLshort y);
    void glVertex2iv(const GLint *v);
    void glVertex2i(GLint x, GLint y);
    void glVertex2fv(const GLfloat *v);
    void glVertex2f(GLfloat x, GLfloat y);
    void glVertex2dv(const GLdouble *v);
    void glVertex2d(GLdouble x, GLdouble y);
    void glTexCoord4sv(const GLshort *v);
    void glTexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q);
    void glTexCoord4iv(const GLint *v);
    void glTexCoord4i(GLint s, GLint t, GLint r, GLint q);
    void glTexCoord4fv(const GLfloat *v);
    void glTexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q);
    void glTexCoord4dv(const GLdouble *v);
    void glTexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q);
    void glTexCoord3sv(const GLshort *v);
    void glTexCoord3s(GLshort s, GLshort t, GLshort r);
    void glTexCoord3iv(const GLint *v);
    void glTexCoord3i(GLint s, GLint t, GLint r);
    void glTexCoord3fv(const GLfloat *v);
    void glTexCoord3f(GLfloat s, GLfloat t, GLfloat r);
    void glTexCoord3dv(const GLdouble *v);
    void glTexCoord3d(GLdouble s, GLdouble t, GLdouble r);
    void glTexCoord2sv(const GLshort *v);
    void glTexCoord2s(GLshort s, GLshort t);
    void glTexCoord2iv(const GLint *v);
    void glTexCoord2i(GLint s, GLint t);
    void glTexCoord2fv(const GLfloat *v);
    void glTexCoord2f(GLfloat s, GLfloat t);
    void glTexCoord2dv(const GLdouble *v);
    void glTexCoord2d(GLdouble s, GLdouble t);
    void glTexCoord1sv(const GLshort *v);
    void glTexCoord1s(GLshort s);
    void glTexCoord1iv(const GLint *v);
    void glTexCoord1i(GLint s);
    void glTexCoord1fv(const GLfloat *v);
    void glTexCoord1f(GLfloat s);
    void glTexCoord1dv(const GLdouble *v);
    void glTexCoord1d(GLdouble s);
    void glRectsv(const GLshort *v1, const GLshort *v2);
    void glRects(GLshort x1, GLshort y1, GLshort x2, GLshort y2);
    void glRectiv(const GLint *v1, const GLint *v2);
    void glRecti(GLint x1, GLint y1, GLint x2, GLint y2);
    void glRectfv(const GLfloat *v1, const GLfloat *v2);
    void glRectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
    void glRectdv(const GLdouble *v1, const GLdouble *v2);
    void glRectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
    void glRasterPos4sv(const GLshort *v);
    void glRasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w);
    void glRasterPos4iv(const GLint *v);
    void glRasterPos4i(GLint x, GLint y, GLint z, GLint w);
    void glRasterPos4fv(const GLfloat *v);
    void glRasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
    void glRasterPos4dv(const GLdouble *v);
    void glRasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
    void glRasterPos3sv(const GLshort *v);
    void glRasterPos3s(GLshort x, GLshort y, GLshort z);
    void glRasterPos3iv(const GLint *v);
    void glRasterPos3i(GLint x, GLint y, GLint z);
    void glRasterPos3fv(const GLfloat *v);
    void glRasterPos3f(GLfloat x, GLfloat y, GLfloat z);
    void glRasterPos3dv(const GLdouble *v);
    void glRasterPos3d(GLdouble x, GLdouble y, GLdouble z);
    void glRasterPos2sv(const GLshort *v);
    void glRasterPos2s(GLshort x, GLshort y);
    void glRasterPos2iv(const GLint *v);
    void glRasterPos2i(GLint x, GLint y);
    void glRasterPos2fv(const GLfloat *v);
    void glRasterPos2f(GLfloat x, GLfloat y);
    void glRasterPos2dv(const GLdouble *v);
    void glRasterPos2d(GLdouble x, GLdouble y);
    void glNormal3sv(const GLshort *v);
    void glNormal3s(GLshort nx, GLshort ny, GLshort nz);
    void glNormal3iv(const GLint *v);
    void glNormal3i(GLint nx, GLint ny, GLint nz);
    void glNormal3fv(const GLfloat *v);
    void glNormal3f(GLfloat nx, GLfloat ny, GLfloat nz);
    void glNormal3dv(const GLdouble *v);
    void glNormal3d(GLdouble nx, GLdouble ny, GLdouble nz);
    void glNormal3bv(const GLbyte *v);
    void glNormal3b(GLbyte nx, GLbyte ny, GLbyte nz);
    void glIndexsv(const GLshort *c);
    void glIndexs(GLshort c);
    void glIndexiv(const GLint *c);
    void glIndexi(GLint c);
    void glIndexfv(const GLfloat *c);
    void glIndexf(GLfloat c);
    void glIndexdv(const GLdouble *c);
    void glIndexd(GLdouble c);
    void glEnd();
    void glEdgeFlagv(const GLboolean *flag);
    void glEdgeFlag(GLboolean flag);
    void glColor4usv(const GLushort *v);
    void glColor4us(GLushort red, GLushort green, GLushort blue, GLushort alpha);
    void glColor4uiv(const GLuint *v);
    void glColor4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha);
    void glColor4ubv(const GLubyte *v);
    void glColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
    void glColor4sv(const GLshort *v);
    void glColor4s(GLshort red, GLshort green, GLshort blue, GLshort alpha);
    void glColor4iv(const GLint *v);
    void glColor4i(GLint red, GLint green, GLint blue, GLint alpha);
    void glColor4fv(const GLfloat *v);
    void glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
    void glColor4dv(const GLdouble *v);
    void glColor4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
    void glColor4bv(const GLbyte *v);
    void glColor4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
    void glColor3usv(const GLushort *v);
    void glColor3us(GLushort red, GLushort green, GLushort blue);
    void glColor3uiv(const GLuint *v);
    void glColor3ui(GLuint red, GLuint green, GLuint blue);
    void glColor3ubv(const GLubyte *v);
    void glColor3ub(GLubyte red, GLubyte green, GLubyte blue);
    void glColor3sv(const GLshort *v);
    void glColor3s(GLshort red, GLshort green, GLshort blue);
    void glColor3iv(const GLint *v);
    void glColor3i(GLint red, GLint green, GLint blue);
    void glColor3fv(const GLfloat *v);
    void glColor3f(GLfloat red, GLfloat green, GLfloat blue);
    void glColor3dv(const GLdouble *v);
    void glColor3d(GLdouble red, GLdouble green, GLdouble blue);
    void glColor3bv(const GLbyte *v);
    void glColor3b(GLbyte red, GLbyte green, GLbyte blue);
    void glBitmap(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
    void glBegin(GLenum mode);
    void glListBase(GLuint base);
    GLuint glGenLists(GLsizei range);
    void glDeleteLists(GLuint list, GLsizei range);
    void glCallLists(GLsizei n, GLenum type, const GLvoid *lists);
    void glCallList(GLuint list);
    void glEndList();
    void glNewList(GLuint list, GLenum mode);

    // OpenGL 1.1 deprecated functions
    void glPushClientAttrib(GLbitfield mask);
    void glPopClientAttrib();
    void glPrioritizeTextures(GLsizei n, const GLuint *textures, const GLfloat *priorities);
    GLboolean glAreTexturesResident(GLsizei n, const GLuint *textures, GLboolean *residences);
    void glVertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glNormalPointer(GLenum type, GLsizei stride, const GLvoid *pointer);
    void glInterleavedArrays(GLenum format, GLsizei stride, const GLvoid *pointer);
    void glIndexPointer(GLenum type, GLsizei stride, const GLvoid *pointer);
    void glEnableClientState(GLenum array);
    void glEdgeFlagPointer(GLsizei stride, const GLvoid *pointer);
    void glDisableClientState(GLenum array);
    void glColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glArrayElement(GLint i);

    // OpenGL 1.2 deprecated functions
    void glResetMinmax(GLenum target);
    void glResetHistogram(GLenum target);
    void glMinmax(GLenum target, GLenum internalformat, GLboolean sink);
    void glHistogram(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink);
    void glGetMinmaxParameteriv(GLenum target, GLenum pname, GLint *params);
    void glGetMinmaxParameterfv(GLenum target, GLenum pname, GLfloat *params);
    void glGetMinmax(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);
    void glGetHistogramParameteriv(GLenum target, GLenum pname, GLint *params);
    void glGetHistogramParameterfv(GLenum target, GLenum pname, GLfloat *params);
    void glGetHistogram(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);
    void glSeparableFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column);
    void glGetSeparableFilter(GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span);
    void glGetConvolutionParameteriv(GLenum target, GLenum pname, GLint *params);
    void glGetConvolutionParameterfv(GLenum target, GLenum pname, GLfloat *params);
    void glGetConvolutionFilter(GLenum target, GLenum format, GLenum type, GLvoid *image);
    void glCopyConvolutionFilter2D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
    void glCopyConvolutionFilter1D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
    void glConvolutionParameteriv(GLenum target, GLenum pname, const GLint *params);
    void glConvolutionParameteri(GLenum target, GLenum pname, GLint params);
    void glConvolutionParameterfv(GLenum target, GLenum pname, const GLfloat *params);
    void glConvolutionParameterf(GLenum target, GLenum pname, GLfloat params);
    void glConvolutionFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image);
    void glConvolutionFilter1D(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image);
    void glCopyColorSubTable(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width);
    void glColorSubTable(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data);
    void glGetColorTableParameteriv(GLenum target, GLenum pname, GLint *params);
    void glGetColorTableParameterfv(GLenum target, GLenum pname, GLfloat *params);
    void glGetColorTable(GLenum target, GLenum format, GLenum type, GLvoid *table);
    void glCopyColorTable(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
    void glColorTableParameteriv(GLenum target, GLenum pname, const GLint *params);
    void glColorTableParameterfv(GLenum target, GLenum pname, const GLfloat *params);
    void glColorTable(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table);

    // OpenGL 1.3 deprecated functions
    void glMultTransposeMatrixd(const GLdouble *m);
    void glMultTransposeMatrixf(const GLfloat *m);
    void glLoadTransposeMatrixd(const GLdouble *m);
    void glLoadTransposeMatrixf(const GLfloat *m);
    void glMultiTexCoord4sv(GLenum target, const GLshort *v);
    void glMultiTexCoord4s(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
    void glMultiTexCoord4iv(GLenum target, const GLint *v);
    void glMultiTexCoord4i(GLenum target, GLint s, GLint t, GLint r, GLint q);
    void glMultiTexCoord4fv(GLenum target, const GLfloat *v);
    void glMultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
    void glMultiTexCoord4dv(GLenum target, const GLdouble *v);
    void glMultiTexCoord4d(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
    void glMultiTexCoord3sv(GLenum target, const GLshort *v);
    void glMultiTexCoord3s(GLenum target, GLshort s, GLshort t, GLshort r);
    void glMultiTexCoord3iv(GLenum target, const GLint *v);
    void glMultiTexCoord3i(GLenum target, GLint s, GLint t, GLint r);
    void glMultiTexCoord3fv(GLenum target, const GLfloat *v);
    void glMultiTexCoord3f(GLenum target, GLfloat s, GLfloat t, GLfloat r);
    void glMultiTexCoord3dv(GLenum target, const GLdouble *v);
    void glMultiTexCoord3d(GLenum target, GLdouble s, GLdouble t, GLdouble r);
    void glMultiTexCoord2sv(GLenum target, const GLshort *v);
    void glMultiTexCoord2s(GLenum target, GLshort s, GLshort t);
    void glMultiTexCoord2iv(GLenum target, const GLint *v);
    void glMultiTexCoord2i(GLenum target, GLint s, GLint t);
    void glMultiTexCoord2fv(GLenum target, const GLfloat *v);
    void glMultiTexCoord2f(GLenum target, GLfloat s, GLfloat t);
    void glMultiTexCoord2dv(GLenum target, const GLdouble *v);
    void glMultiTexCoord2d(GLenum target, GLdouble s, GLdouble t);
    void glMultiTexCoord1sv(GLenum target, const GLshort *v);
    void glMultiTexCoord1s(GLenum target, GLshort s);
    void glMultiTexCoord1iv(GLenum target, const GLint *v);
    void glMultiTexCoord1i(GLenum target, GLint s);
    void glMultiTexCoord1fv(GLenum target, const GLfloat *v);
    void glMultiTexCoord1f(GLenum target, GLfloat s);
    void glMultiTexCoord1dv(GLenum target, const GLdouble *v);
    void glMultiTexCoord1d(GLenum target, GLdouble s);
    void glClientActiveTexture(GLenum texture);

    // OpenGL 1.4 deprecated functions
    void glWindowPos3sv(const GLshort *v);
    void glWindowPos3s(GLshort x, GLshort y, GLshort z);
    void glWindowPos3iv(const GLint *v);
    void glWindowPos3i(GLint x, GLint y, GLint z);
    void glWindowPos3fv(const GLfloat *v);
    void glWindowPos3f(GLfloat x, GLfloat y, GLfloat z);
    void glWindowPos3dv(const GLdouble *v);
    void glWindowPos3d(GLdouble x, GLdouble y, GLdouble z);
    void glWindowPos2sv(const GLshort *v);
    void glWindowPos2s(GLshort x, GLshort y);
    void glWindowPos2iv(const GLint *v);
    void glWindowPos2i(GLint x, GLint y);
    void glWindowPos2fv(const GLfloat *v);
    void glWindowPos2f(GLfloat x, GLfloat y);
    void glWindowPos2dv(const GLdouble *v);
    void glWindowPos2d(GLdouble x, GLdouble y);
    void glSecondaryColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glSecondaryColor3usv(const GLushort *v);
    void glSecondaryColor3us(GLushort red, GLushort green, GLushort blue);
    void glSecondaryColor3uiv(const GLuint *v);
    void glSecondaryColor3ui(GLuint red, GLuint green, GLuint blue);
    void glSecondaryColor3ubv(const GLubyte *v);
    void glSecondaryColor3ub(GLubyte red, GLubyte green, GLubyte blue);
    void glSecondaryColor3sv(const GLshort *v);
    void glSecondaryColor3s(GLshort red, GLshort green, GLshort blue);
    void glSecondaryColor3iv(const GLint *v);
    void glSecondaryColor3i(GLint red, GLint green, GLint blue);
    void glSecondaryColor3fv(const GLfloat *v);
    void glSecondaryColor3f(GLfloat red, GLfloat green, GLfloat blue);
    void glSecondaryColor3dv(const GLdouble *v);
    void glSecondaryColor3d(GLdouble red, GLdouble green, GLdouble blue);
    void glSecondaryColor3bv(const GLbyte *v);
    void glSecondaryColor3b(GLbyte red, GLbyte green, GLbyte blue);
    void glFogCoordPointer(GLenum type, GLsizei stride, const GLvoid *pointer);
    void glFogCoorddv(const GLdouble *coord);
    void glFogCoordd(GLdouble coord);
    void glFogCoordfv(const GLfloat *coord);
    void glFogCoordf(GLfloat coord);

    // OpenGL 1.5 deprecated functions

private:
    friend class QOpenGLVersionFunctionsFactory;

    static bool isContextCompatible(QOpenGLContext *context);
    static QOpenGLVersionProfile versionProfile();

    QOpenGLFunctions_1_0_CoreBackend* d_1_0_Core;
    QOpenGLFunctions_1_1_CoreBackend* d_1_1_Core;
    QOpenGLFunctions_1_2_CoreBackend* d_1_2_Core;
    QOpenGLFunctions_1_3_CoreBackend* d_1_3_Core;
    QOpenGLFunctions_1_4_CoreBackend* d_1_4_Core;
    QOpenGLFunctions_1_5_CoreBackend* d_1_5_Core;
    QOpenGLFunctions_1_0_DeprecatedBackend* d_1_0_Deprecated;
    QOpenGLFunctions_1_1_DeprecatedBackend* d_1_1_Deprecated;
    QOpenGLFunctions_1_2_DeprecatedBackend* d_1_2_Deprecated;
    QOpenGLFunctions_1_3_DeprecatedBackend* d_1_3_Deprecated;
    QOpenGLFunctions_1_4_DeprecatedBackend* d_1_4_Deprecated;
};

// OpenGL 1.0 core functions
inline void QOpenGLFunctions_1_5::glViewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
    d_1_0_Core->f.Viewport(x, y, width, height);
}

inline void QOpenGLFunctions_1_5::glDepthRange(GLdouble nearVal, GLdouble farVal)
{
    d_1_0_Core->f.DepthRange(nearVal, farVal);
}

inline GLboolean QOpenGLFunctions_1_5::glIsEnabled(GLenum cap)
{
    return d_1_0_Core->f.IsEnabled(cap);
}

inline void QOpenGLFunctions_1_5::glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params)
{
    d_1_0_Core->f.GetTexLevelParameteriv(target, level, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat *params)
{
    d_1_0_Core->f.GetTexLevelParameterfv(target, level, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetTexParameteriv(GLenum target, GLenum pname, GLint *params)
{
    d_1_0_Core->f.GetTexParameteriv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetTexParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    d_1_0_Core->f.GetTexParameterfv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)
{
    d_1_0_Core->f.GetTexImage(target, level, format, type, pixels);
}

inline const GLubyte * QOpenGLFunctions_1_5::glGetString(GLenum name)
{
    return d_1_0_Core->f.GetString(name);
}

inline void QOpenGLFunctions_1_5::glGetIntegerv(GLenum pname, GLint *params)
{
    d_1_0_Core->f.GetIntegerv(pname, params);
}

inline void QOpenGLFunctions_1_5::glGetFloatv(GLenum pname, GLfloat *params)
{
    d_1_0_Core->f.GetFloatv(pname, params);
}

inline GLenum QOpenGLFunctions_1_5::glGetError()
{
    return d_1_0_Core->f.GetError();
}

inline void QOpenGLFunctions_1_5::glGetDoublev(GLenum pname, GLdouble *params)
{
    d_1_0_Core->f.GetDoublev(pname, params);
}

inline void QOpenGLFunctions_1_5::glGetBooleanv(GLenum pname, GLboolean *params)
{
    d_1_0_Core->f.GetBooleanv(pname, params);
}

inline void QOpenGLFunctions_1_5::glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)
{
    d_1_0_Core->f.ReadPixels(x, y, width, height, format, type, pixels);
}

inline void QOpenGLFunctions_1_5::glReadBuffer(GLenum mode)
{
    d_1_0_Core->f.ReadBuffer(mode);
}

inline void QOpenGLFunctions_1_5::glPixelStorei(GLenum pname, GLint param)
{
    d_1_0_Core->f.PixelStorei(pname, param);
}

inline void QOpenGLFunctions_1_5::glPixelStoref(GLenum pname, GLfloat param)
{
    d_1_0_Core->f.PixelStoref(pname, param);
}

inline void QOpenGLFunctions_1_5::glDepthFunc(GLenum func)
{
    d_1_0_Core->f.DepthFunc(func);
}

inline void QOpenGLFunctions_1_5::glStencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
    d_1_0_Core->f.StencilOp(fail, zfail, zpass);
}

inline void QOpenGLFunctions_1_5::glStencilFunc(GLenum func, GLint ref, GLuint mask)
{
    d_1_0_Core->f.StencilFunc(func, ref, mask);
}

inline void QOpenGLFunctions_1_5::glLogicOp(GLenum opcode)
{
    d_1_0_Core->f.LogicOp(opcode);
}

inline void QOpenGLFunctions_1_5::glBlendFunc(GLenum sfactor, GLenum dfactor)
{
    d_1_0_Core->f.BlendFunc(sfactor, dfactor);
}

inline void QOpenGLFunctions_1_5::glFlush()
{
    d_1_0_Core->f.Flush();
}

inline void QOpenGLFunctions_1_5::glFinish()
{
    d_1_0_Core->f.Finish();
}

inline void QOpenGLFunctions_1_5::glEnable(GLenum cap)
{
    d_1_0_Core->f.Enable(cap);
}

inline void QOpenGLFunctions_1_5::glDisable(GLenum cap)
{
    d_1_0_Core->f.Disable(cap);
}

inline void QOpenGLFunctions_1_5::glDepthMask(GLboolean flag)
{
    d_1_0_Core->f.DepthMask(flag);
}

inline void QOpenGLFunctions_1_5::glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
    d_1_0_Core->f.ColorMask(red, green, blue, alpha);
}

inline void QOpenGLFunctions_1_5::glStencilMask(GLuint mask)
{
    d_1_0_Core->f.StencilMask(mask);
}

inline void QOpenGLFunctions_1_5::glClearDepth(GLdouble depth)
{
    d_1_0_Core->f.ClearDepth(depth);
}

inline void QOpenGLFunctions_1_5::glClearStencil(GLint s)
{
    d_1_0_Core->f.ClearStencil(s);
}

inline void QOpenGLFunctions_1_5::glClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    d_1_0_Core->f.ClearColor(red, green, blue, alpha);
}

inline void QOpenGLFunctions_1_5::glClear(GLbitfield mask)
{
    d_1_0_Core->f.Clear(mask);
}

inline void QOpenGLFunctions_1_5::glDrawBuffer(GLenum mode)
{
    d_1_0_Core->f.DrawBuffer(mode);
}

inline void QOpenGLFunctions_1_5::glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_0_Core->f.TexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
}

inline void QOpenGLFunctions_1_5::glTexImage1D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_0_Core->f.TexImage1D(target, level, internalformat, width, border, format, type, pixels);
}

inline void QOpenGLFunctions_1_5::glTexParameteriv(GLenum target, GLenum pname, const GLint *params)
{
    d_1_0_Core->f.TexParameteriv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glTexParameteri(GLenum target, GLenum pname, GLint param)
{
    d_1_0_Core->f.TexParameteri(target, pname, param);
}

inline void QOpenGLFunctions_1_5::glTexParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
    d_1_0_Core->f.TexParameterfv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glTexParameterf(GLenum target, GLenum pname, GLfloat param)
{
    d_1_0_Core->f.TexParameterf(target, pname, param);
}

inline void QOpenGLFunctions_1_5::glScissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
    d_1_0_Core->f.Scissor(x, y, width, height);
}

inline void QOpenGLFunctions_1_5::glPolygonMode(GLenum face, GLenum mode)
{
    d_1_0_Core->f.PolygonMode(face, mode);
}

inline void QOpenGLFunctions_1_5::glPointSize(GLfloat size)
{
    d_1_0_Core->f.PointSize(size);
}

inline void QOpenGLFunctions_1_5::glLineWidth(GLfloat width)
{
    d_1_0_Core->f.LineWidth(width);
}

inline void QOpenGLFunctions_1_5::glHint(GLenum target, GLenum mode)
{
    d_1_0_Core->f.Hint(target, mode);
}

inline void QOpenGLFunctions_1_5::glFrontFace(GLenum mode)
{
    d_1_0_Core->f.FrontFace(mode);
}

inline void QOpenGLFunctions_1_5::glCullFace(GLenum mode)
{
    d_1_0_Core->f.CullFace(mode);
}


// OpenGL 1.1 core functions
inline void QOpenGLFunctions_1_5::glIndexubv(const GLubyte *c)
{
    d_1_1_Deprecated->f.Indexubv(c);
}

inline void QOpenGLFunctions_1_5::glIndexub(GLubyte c)
{
    d_1_1_Deprecated->f.Indexub(c);
}

inline GLboolean QOpenGLFunctions_1_5::glIsTexture(GLuint texture)
{
    return d_1_1_Core->f.IsTexture(texture);
}

inline void QOpenGLFunctions_1_5::glGenTextures(GLsizei n, GLuint *textures)
{
    d_1_1_Core->f.GenTextures(n, textures);
}

inline void QOpenGLFunctions_1_5::glDeleteTextures(GLsizei n, const GLuint *textures)
{
    d_1_1_Core->f.DeleteTextures(n, textures);
}

inline void QOpenGLFunctions_1_5::glBindTexture(GLenum target, GLuint texture)
{
    d_1_1_Core->f.BindTexture(target, texture);
}

inline void QOpenGLFunctions_1_5::glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_1_Core->f.TexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
}

inline void QOpenGLFunctions_1_5::glTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_1_Core->f.TexSubImage1D(target, level, xoffset, width, format, type, pixels);
}

inline void QOpenGLFunctions_1_5::glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    d_1_1_Core->f.CopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
}

inline void QOpenGLFunctions_1_5::glCopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
    d_1_1_Core->f.CopyTexSubImage1D(target, level, xoffset, x, y, width);
}

inline void QOpenGLFunctions_1_5::glCopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
    d_1_1_Core->f.CopyTexImage2D(target, level, internalformat, x, y, width, height, border);
}

inline void QOpenGLFunctions_1_5::glCopyTexImage1D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
    d_1_1_Core->f.CopyTexImage1D(target, level, internalformat, x, y, width, border);
}

inline void QOpenGLFunctions_1_5::glPolygonOffset(GLfloat factor, GLfloat units)
{
    d_1_1_Core->f.PolygonOffset(factor, units);
}

inline void QOpenGLFunctions_1_5::glGetPointerv(GLenum pname, GLvoid* *params)
{
    d_1_1_Deprecated->f.GetPointerv(pname, params);
}

inline void QOpenGLFunctions_1_5::glDrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices)
{
    d_1_1_Core->f.DrawElements(mode, count, type, indices);
}

inline void QOpenGLFunctions_1_5::glDrawArrays(GLenum mode, GLint first, GLsizei count)
{
    d_1_1_Core->f.DrawArrays(mode, first, count);
}


// OpenGL 1.2 core functions
inline void QOpenGLFunctions_1_5::glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    d_1_2_Core->f.CopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

inline void QOpenGLFunctions_1_5::glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_2_Core->f.TexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}

inline void QOpenGLFunctions_1_5::glTexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_2_Core->f.TexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixels);
}

inline void QOpenGLFunctions_1_5::glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices)
{
    d_1_2_Core->f.DrawRangeElements(mode, start, end, count, type, indices);
}

inline void QOpenGLFunctions_1_5::glBlendEquation(GLenum mode)
{
    d_1_2_Core->f.BlendEquation(mode);
}

inline void QOpenGLFunctions_1_5::glBlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    d_1_2_Core->f.BlendColor(red, green, blue, alpha);
}


// OpenGL 1.3 core functions
inline void QOpenGLFunctions_1_5::glGetCompressedTexImage(GLenum target, GLint level, GLvoid *img)
{
    d_1_3_Core->f.GetCompressedTexImage(target, level, img);
}

inline void QOpenGLFunctions_1_5::glCompressedTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data)
{
    d_1_3_Core->f.CompressedTexSubImage1D(target, level, xoffset, width, format, imageSize, data);
}

inline void QOpenGLFunctions_1_5::glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data)
{
    d_1_3_Core->f.CompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
}

inline void QOpenGLFunctions_1_5::glCompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data)
{
    d_1_3_Core->f.CompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
}

inline void QOpenGLFunctions_1_5::glCompressedTexImage1D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data)
{
    d_1_3_Core->f.CompressedTexImage1D(target, level, internalformat, width, border, imageSize, data);
}

inline void QOpenGLFunctions_1_5::glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data)
{
    d_1_3_Core->f.CompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
}

inline void QOpenGLFunctions_1_5::glCompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data)
{
    d_1_3_Core->f.CompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, data);
}

inline void QOpenGLFunctions_1_5::glSampleCoverage(GLfloat value, GLboolean invert)
{
    d_1_3_Core->f.SampleCoverage(value, invert);
}

inline void QOpenGLFunctions_1_5::glActiveTexture(GLenum texture)
{
    d_1_3_Core->f.ActiveTexture(texture);
}


// OpenGL 1.4 core functions
inline void QOpenGLFunctions_1_5::glPointParameteriv(GLenum pname, const GLint *params)
{
    d_1_4_Core->f.PointParameteriv(pname, params);
}

inline void QOpenGLFunctions_1_5::glPointParameteri(GLenum pname, GLint param)
{
    d_1_4_Core->f.PointParameteri(pname, param);
}

inline void QOpenGLFunctions_1_5::glPointParameterfv(GLenum pname, const GLfloat *params)
{
    d_1_4_Core->f.PointParameterfv(pname, params);
}

inline void QOpenGLFunctions_1_5::glPointParameterf(GLenum pname, GLfloat param)
{
    d_1_4_Core->f.PointParameterf(pname, param);
}

inline void QOpenGLFunctions_1_5::glMultiDrawElements(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount)
{
    d_1_4_Core->f.MultiDrawElements(mode, count, type, indices, drawcount);
}

inline void QOpenGLFunctions_1_5::glMultiDrawArrays(GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount)
{
    d_1_4_Core->f.MultiDrawArrays(mode, first, count, drawcount);
}

inline void QOpenGLFunctions_1_5::glBlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)
{
    d_1_4_Core->f.BlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
}


// OpenGL 1.5 core functions
inline void QOpenGLFunctions_1_5::glGetBufferPointerv(GLenum target, GLenum pname, GLvoid* *params)
{
    d_1_5_Core->f.GetBufferPointerv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetBufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    d_1_5_Core->f.GetBufferParameteriv(target, pname, params);
}

inline GLboolean QOpenGLFunctions_1_5::glUnmapBuffer(GLenum target)
{
    return d_1_5_Core->f.UnmapBuffer(target);
}

inline GLvoid* QOpenGLFunctions_1_5::glMapBuffer(GLenum target, GLenum access)
{
    return d_1_5_Core->f.MapBuffer(target, access);
}

inline void QOpenGLFunctions_1_5::glGetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid *data)
{
    d_1_5_Core->f.GetBufferSubData(target, offset, size, data);
}

inline void QOpenGLFunctions_1_5::glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid *data)
{
    d_1_5_Core->f.BufferSubData(target, offset, size, data);
}

inline void QOpenGLFunctions_1_5::glBufferData(GLenum target, GLsizeiptr size, const GLvoid *data, GLenum usage)
{
    d_1_5_Core->f.BufferData(target, size, data, usage);
}

inline GLboolean QOpenGLFunctions_1_5::glIsBuffer(GLuint buffer)
{
    return d_1_5_Core->f.IsBuffer(buffer);
}

inline void QOpenGLFunctions_1_5::glGenBuffers(GLsizei n, GLuint *buffers)
{
    d_1_5_Core->f.GenBuffers(n, buffers);
}

inline void QOpenGLFunctions_1_5::glDeleteBuffers(GLsizei n, const GLuint *buffers)
{
    d_1_5_Core->f.DeleteBuffers(n, buffers);
}

inline void QOpenGLFunctions_1_5::glBindBuffer(GLenum target, GLuint buffer)
{
    d_1_5_Core->f.BindBuffer(target, buffer);
}

inline void QOpenGLFunctions_1_5::glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint *params)
{
    d_1_5_Core->f.GetQueryObjectuiv(id, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetQueryObjectiv(GLuint id, GLenum pname, GLint *params)
{
    d_1_5_Core->f.GetQueryObjectiv(id, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetQueryiv(GLenum target, GLenum pname, GLint *params)
{
    d_1_5_Core->f.GetQueryiv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glEndQuery(GLenum target)
{
    d_1_5_Core->f.EndQuery(target);
}

inline void QOpenGLFunctions_1_5::glBeginQuery(GLenum target, GLuint id)
{
    d_1_5_Core->f.BeginQuery(target, id);
}

inline GLboolean QOpenGLFunctions_1_5::glIsQuery(GLuint id)
{
    return d_1_5_Core->f.IsQuery(id);
}

inline void QOpenGLFunctions_1_5::glDeleteQueries(GLsizei n, const GLuint *ids)
{
    d_1_5_Core->f.DeleteQueries(n, ids);
}

inline void QOpenGLFunctions_1_5::glGenQueries(GLsizei n, GLuint *ids)
{
    d_1_5_Core->f.GenQueries(n, ids);
}


// OpenGL 1.0 deprecated functions
inline void QOpenGLFunctions_1_5::glTranslatef(GLfloat x, GLfloat y, GLfloat z)
{
    d_1_0_Deprecated->f.Translatef(x, y, z);
}

inline void QOpenGLFunctions_1_5::glTranslated(GLdouble x, GLdouble y, GLdouble z)
{
    d_1_0_Deprecated->f.Translated(x, y, z);
}

inline void QOpenGLFunctions_1_5::glScalef(GLfloat x, GLfloat y, GLfloat z)
{
    d_1_0_Deprecated->f.Scalef(x, y, z);
}

inline void QOpenGLFunctions_1_5::glScaled(GLdouble x, GLdouble y, GLdouble z)
{
    d_1_0_Deprecated->f.Scaled(x, y, z);
}

inline void QOpenGLFunctions_1_5::glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    d_1_0_Deprecated->f.Rotatef(angle, x, y, z);
}

inline void QOpenGLFunctions_1_5::glRotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z)
{
    d_1_0_Deprecated->f.Rotated(angle, x, y, z);
}

inline void QOpenGLFunctions_1_5::glPushMatrix()
{
    d_1_0_Deprecated->f.PushMatrix();
}

inline void QOpenGLFunctions_1_5::glPopMatrix()
{
    d_1_0_Deprecated->f.PopMatrix();
}

inline void QOpenGLFunctions_1_5::glOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
    d_1_0_Deprecated->f.Ortho(left, right, bottom, top, zNear, zFar);
}

inline void QOpenGLFunctions_1_5::glMultMatrixd(const GLdouble *m)
{
    d_1_0_Deprecated->f.MultMatrixd(m);
}

inline void QOpenGLFunctions_1_5::glMultMatrixf(const GLfloat *m)
{
    d_1_0_Deprecated->f.MultMatrixf(m);
}

inline void QOpenGLFunctions_1_5::glMatrixMode(GLenum mode)
{
    d_1_0_Deprecated->f.MatrixMode(mode);
}

inline void QOpenGLFunctions_1_5::glLoadMatrixd(const GLdouble *m)
{
    d_1_0_Deprecated->f.LoadMatrixd(m);
}

inline void QOpenGLFunctions_1_5::glLoadMatrixf(const GLfloat *m)
{
    d_1_0_Deprecated->f.LoadMatrixf(m);
}

inline void QOpenGLFunctions_1_5::glLoadIdentity()
{
    d_1_0_Deprecated->f.LoadIdentity();
}

inline void QOpenGLFunctions_1_5::glFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
    d_1_0_Deprecated->f.Frustum(left, right, bottom, top, zNear, zFar);
}

inline GLboolean QOpenGLFunctions_1_5::glIsList(GLuint list)
{
    return d_1_0_Deprecated->f.IsList(list);
}

inline void QOpenGLFunctions_1_5::glGetTexGeniv(GLenum coord, GLenum pname, GLint *params)
{
    d_1_0_Deprecated->f.GetTexGeniv(coord, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetTexGenfv(GLenum coord, GLenum pname, GLfloat *params)
{
    d_1_0_Deprecated->f.GetTexGenfv(coord, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetTexGendv(GLenum coord, GLenum pname, GLdouble *params)
{
    d_1_0_Deprecated->f.GetTexGendv(coord, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetTexEnviv(GLenum target, GLenum pname, GLint *params)
{
    d_1_0_Deprecated->f.GetTexEnviv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetTexEnvfv(GLenum target, GLenum pname, GLfloat *params)
{
    d_1_0_Deprecated->f.GetTexEnvfv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetPolygonStipple(GLubyte *mask)
{
    d_1_0_Deprecated->f.GetPolygonStipple(mask);
}

inline void QOpenGLFunctions_1_5::glGetPixelMapusv(GLenum map, GLushort *values)
{
    d_1_0_Deprecated->f.GetPixelMapusv(map, values);
}

inline void QOpenGLFunctions_1_5::glGetPixelMapuiv(GLenum map, GLuint *values)
{
    d_1_0_Deprecated->f.GetPixelMapuiv(map, values);
}

inline void QOpenGLFunctions_1_5::glGetPixelMapfv(GLenum map, GLfloat *values)
{
    d_1_0_Deprecated->f.GetPixelMapfv(map, values);
}

inline void QOpenGLFunctions_1_5::glGetMaterialiv(GLenum face, GLenum pname, GLint *params)
{
    d_1_0_Deprecated->f.GetMaterialiv(face, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetMaterialfv(GLenum face, GLenum pname, GLfloat *params)
{
    d_1_0_Deprecated->f.GetMaterialfv(face, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetMapiv(GLenum target, GLenum query, GLint *v)
{
    d_1_0_Deprecated->f.GetMapiv(target, query, v);
}

inline void QOpenGLFunctions_1_5::glGetMapfv(GLenum target, GLenum query, GLfloat *v)
{
    d_1_0_Deprecated->f.GetMapfv(target, query, v);
}

inline void QOpenGLFunctions_1_5::glGetMapdv(GLenum target, GLenum query, GLdouble *v)
{
    d_1_0_Deprecated->f.GetMapdv(target, query, v);
}

inline void QOpenGLFunctions_1_5::glGetLightiv(GLenum light, GLenum pname, GLint *params)
{
    d_1_0_Deprecated->f.GetLightiv(light, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetLightfv(GLenum light, GLenum pname, GLfloat *params)
{
    d_1_0_Deprecated->f.GetLightfv(light, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetClipPlane(GLenum plane, GLdouble *equation)
{
    d_1_0_Deprecated->f.GetClipPlane(plane, equation);
}

inline void QOpenGLFunctions_1_5::glDrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_0_Deprecated->f.DrawPixels(width, height, format, type, pixels);
}

inline void QOpenGLFunctions_1_5::glCopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)
{
    d_1_0_Deprecated->f.CopyPixels(x, y, width, height, type);
}

inline void QOpenGLFunctions_1_5::glPixelMapusv(GLenum map, GLint mapsize, const GLushort *values)
{
    d_1_0_Deprecated->f.PixelMapusv(map, mapsize, values);
}

inline void QOpenGLFunctions_1_5::glPixelMapuiv(GLenum map, GLint mapsize, const GLuint *values)
{
    d_1_0_Deprecated->f.PixelMapuiv(map, mapsize, values);
}

inline void QOpenGLFunctions_1_5::glPixelMapfv(GLenum map, GLint mapsize, const GLfloat *values)
{
    d_1_0_Deprecated->f.PixelMapfv(map, mapsize, values);
}

inline void QOpenGLFunctions_1_5::glPixelTransferi(GLenum pname, GLint param)
{
    d_1_0_Deprecated->f.PixelTransferi(pname, param);
}

inline void QOpenGLFunctions_1_5::glPixelTransferf(GLenum pname, GLfloat param)
{
    d_1_0_Deprecated->f.PixelTransferf(pname, param);
}

inline void QOpenGLFunctions_1_5::glPixelZoom(GLfloat xfactor, GLfloat yfactor)
{
    d_1_0_Deprecated->f.PixelZoom(xfactor, yfactor);
}

inline void QOpenGLFunctions_1_5::glAlphaFunc(GLenum func, GLfloat ref)
{
    d_1_0_Deprecated->f.AlphaFunc(func, ref);
}

inline void QOpenGLFunctions_1_5::glEvalPoint2(GLint i, GLint j)
{
    d_1_0_Deprecated->f.EvalPoint2(i, j);
}

inline void QOpenGLFunctions_1_5::glEvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)
{
    d_1_0_Deprecated->f.EvalMesh2(mode, i1, i2, j1, j2);
}

inline void QOpenGLFunctions_1_5::glEvalPoint1(GLint i)
{
    d_1_0_Deprecated->f.EvalPoint1(i);
}

inline void QOpenGLFunctions_1_5::glEvalMesh1(GLenum mode, GLint i1, GLint i2)
{
    d_1_0_Deprecated->f.EvalMesh1(mode, i1, i2);
}

inline void QOpenGLFunctions_1_5::glEvalCoord2fv(const GLfloat *u)
{
    d_1_0_Deprecated->f.EvalCoord2fv(u);
}

inline void QOpenGLFunctions_1_5::glEvalCoord2f(GLfloat u, GLfloat v)
{
    d_1_0_Deprecated->f.EvalCoord2f(u, v);
}

inline void QOpenGLFunctions_1_5::glEvalCoord2dv(const GLdouble *u)
{
    d_1_0_Deprecated->f.EvalCoord2dv(u);
}

inline void QOpenGLFunctions_1_5::glEvalCoord2d(GLdouble u, GLdouble v)
{
    d_1_0_Deprecated->f.EvalCoord2d(u, v);
}

inline void QOpenGLFunctions_1_5::glEvalCoord1fv(const GLfloat *u)
{
    d_1_0_Deprecated->f.EvalCoord1fv(u);
}

inline void QOpenGLFunctions_1_5::glEvalCoord1f(GLfloat u)
{
    d_1_0_Deprecated->f.EvalCoord1f(u);
}

inline void QOpenGLFunctions_1_5::glEvalCoord1dv(const GLdouble *u)
{
    d_1_0_Deprecated->f.EvalCoord1dv(u);
}

inline void QOpenGLFunctions_1_5::glEvalCoord1d(GLdouble u)
{
    d_1_0_Deprecated->f.EvalCoord1d(u);
}

inline void QOpenGLFunctions_1_5::glMapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2)
{
    d_1_0_Deprecated->f.MapGrid2f(un, u1, u2, vn, v1, v2);
}

inline void QOpenGLFunctions_1_5::glMapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2)
{
    d_1_0_Deprecated->f.MapGrid2d(un, u1, u2, vn, v1, v2);
}

inline void QOpenGLFunctions_1_5::glMapGrid1f(GLint un, GLfloat u1, GLfloat u2)
{
    d_1_0_Deprecated->f.MapGrid1f(un, u1, u2);
}

inline void QOpenGLFunctions_1_5::glMapGrid1d(GLint un, GLdouble u1, GLdouble u2)
{
    d_1_0_Deprecated->f.MapGrid1d(un, u1, u2);
}

inline void QOpenGLFunctions_1_5::glMap2f(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)
{
    d_1_0_Deprecated->f.Map2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

inline void QOpenGLFunctions_1_5::glMap2d(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)
{
    d_1_0_Deprecated->f.Map2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

inline void QOpenGLFunctions_1_5::glMap1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)
{
    d_1_0_Deprecated->f.Map1f(target, u1, u2, stride, order, points);
}

inline void QOpenGLFunctions_1_5::glMap1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)
{
    d_1_0_Deprecated->f.Map1d(target, u1, u2, stride, order, points);
}

inline void QOpenGLFunctions_1_5::glPushAttrib(GLbitfield mask)
{
    d_1_0_Deprecated->f.PushAttrib(mask);
}

inline void QOpenGLFunctions_1_5::glPopAttrib()
{
    d_1_0_Deprecated->f.PopAttrib();
}

inline void QOpenGLFunctions_1_5::glAccum(GLenum op, GLfloat value)
{
    d_1_0_Deprecated->f.Accum(op, value);
}

inline void QOpenGLFunctions_1_5::glIndexMask(GLuint mask)
{
    d_1_0_Deprecated->f.IndexMask(mask);
}

inline void QOpenGLFunctions_1_5::glClearIndex(GLfloat c)
{
    d_1_0_Deprecated->f.ClearIndex(c);
}

inline void QOpenGLFunctions_1_5::glClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    d_1_0_Deprecated->f.ClearAccum(red, green, blue, alpha);
}

inline void QOpenGLFunctions_1_5::glPushName(GLuint name)
{
    d_1_0_Deprecated->f.PushName(name);
}

inline void QOpenGLFunctions_1_5::glPopName()
{
    d_1_0_Deprecated->f.PopName();
}

inline void QOpenGLFunctions_1_5::glPassThrough(GLfloat token)
{
    d_1_0_Deprecated->f.PassThrough(token);
}

inline void QOpenGLFunctions_1_5::glLoadName(GLuint name)
{
    d_1_0_Deprecated->f.LoadName(name);
}

inline void QOpenGLFunctions_1_5::glInitNames()
{
    d_1_0_Deprecated->f.InitNames();
}

inline GLint QOpenGLFunctions_1_5::glRenderMode(GLenum mode)
{
    return d_1_0_Deprecated->f.RenderMode(mode);
}

inline void QOpenGLFunctions_1_5::glSelectBuffer(GLsizei size, GLuint *buffer)
{
    d_1_0_Deprecated->f.SelectBuffer(size, buffer);
}

inline void QOpenGLFunctions_1_5::glFeedbackBuffer(GLsizei size, GLenum type, GLfloat *buffer)
{
    d_1_0_Deprecated->f.FeedbackBuffer(size, type, buffer);
}

inline void QOpenGLFunctions_1_5::glTexGeniv(GLenum coord, GLenum pname, const GLint *params)
{
    d_1_0_Deprecated->f.TexGeniv(coord, pname, params);
}

inline void QOpenGLFunctions_1_5::glTexGeni(GLenum coord, GLenum pname, GLint param)
{
    d_1_0_Deprecated->f.TexGeni(coord, pname, param);
}

inline void QOpenGLFunctions_1_5::glTexGenfv(GLenum coord, GLenum pname, const GLfloat *params)
{
    d_1_0_Deprecated->f.TexGenfv(coord, pname, params);
}

inline void QOpenGLFunctions_1_5::glTexGenf(GLenum coord, GLenum pname, GLfloat param)
{
    d_1_0_Deprecated->f.TexGenf(coord, pname, param);
}

inline void QOpenGLFunctions_1_5::glTexGendv(GLenum coord, GLenum pname, const GLdouble *params)
{
    d_1_0_Deprecated->f.TexGendv(coord, pname, params);
}

inline void QOpenGLFunctions_1_5::glTexGend(GLenum coord, GLenum pname, GLdouble param)
{
    d_1_0_Deprecated->f.TexGend(coord, pname, param);
}

inline void QOpenGLFunctions_1_5::glTexEnviv(GLenum target, GLenum pname, const GLint *params)
{
    d_1_0_Deprecated->f.TexEnviv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glTexEnvi(GLenum target, GLenum pname, GLint param)
{
    d_1_0_Deprecated->f.TexEnvi(target, pname, param);
}

inline void QOpenGLFunctions_1_5::glTexEnvfv(GLenum target, GLenum pname, const GLfloat *params)
{
    d_1_0_Deprecated->f.TexEnvfv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glTexEnvf(GLenum target, GLenum pname, GLfloat param)
{
    d_1_0_Deprecated->f.TexEnvf(target, pname, param);
}

inline void QOpenGLFunctions_1_5::glShadeModel(GLenum mode)
{
    d_1_0_Deprecated->f.ShadeModel(mode);
}

inline void QOpenGLFunctions_1_5::glPolygonStipple(const GLubyte *mask)
{
    d_1_0_Deprecated->f.PolygonStipple(mask);
}

inline void QOpenGLFunctions_1_5::glMaterialiv(GLenum face, GLenum pname, const GLint *params)
{
    d_1_0_Deprecated->f.Materialiv(face, pname, params);
}

inline void QOpenGLFunctions_1_5::glMateriali(GLenum face, GLenum pname, GLint param)
{
    d_1_0_Deprecated->f.Materiali(face, pname, param);
}

inline void QOpenGLFunctions_1_5::glMaterialfv(GLenum face, GLenum pname, const GLfloat *params)
{
    d_1_0_Deprecated->f.Materialfv(face, pname, params);
}

inline void QOpenGLFunctions_1_5::glMaterialf(GLenum face, GLenum pname, GLfloat param)
{
    d_1_0_Deprecated->f.Materialf(face, pname, param);
}

inline void QOpenGLFunctions_1_5::glLineStipple(GLint factor, GLushort pattern)
{
    d_1_0_Deprecated->f.LineStipple(factor, pattern);
}

inline void QOpenGLFunctions_1_5::glLightModeliv(GLenum pname, const GLint *params)
{
    d_1_0_Deprecated->f.LightModeliv(pname, params);
}

inline void QOpenGLFunctions_1_5::glLightModeli(GLenum pname, GLint param)
{
    d_1_0_Deprecated->f.LightModeli(pname, param);
}

inline void QOpenGLFunctions_1_5::glLightModelfv(GLenum pname, const GLfloat *params)
{
    d_1_0_Deprecated->f.LightModelfv(pname, params);
}

inline void QOpenGLFunctions_1_5::glLightModelf(GLenum pname, GLfloat param)
{
    d_1_0_Deprecated->f.LightModelf(pname, param);
}

inline void QOpenGLFunctions_1_5::glLightiv(GLenum light, GLenum pname, const GLint *params)
{
    d_1_0_Deprecated->f.Lightiv(light, pname, params);
}

inline void QOpenGLFunctions_1_5::glLighti(GLenum light, GLenum pname, GLint param)
{
    d_1_0_Deprecated->f.Lighti(light, pname, param);
}

inline void QOpenGLFunctions_1_5::glLightfv(GLenum light, GLenum pname, const GLfloat *params)
{
    d_1_0_Deprecated->f.Lightfv(light, pname, params);
}

inline void QOpenGLFunctions_1_5::glLightf(GLenum light, GLenum pname, GLfloat param)
{
    d_1_0_Deprecated->f.Lightf(light, pname, param);
}

inline void QOpenGLFunctions_1_5::glFogiv(GLenum pname, const GLint *params)
{
    d_1_0_Deprecated->f.Fogiv(pname, params);
}

inline void QOpenGLFunctions_1_5::glFogi(GLenum pname, GLint param)
{
    d_1_0_Deprecated->f.Fogi(pname, param);
}

inline void QOpenGLFunctions_1_5::glFogfv(GLenum pname, const GLfloat *params)
{
    d_1_0_Deprecated->f.Fogfv(pname, params);
}

inline void QOpenGLFunctions_1_5::glFogf(GLenum pname, GLfloat param)
{
    d_1_0_Deprecated->f.Fogf(pname, param);
}

inline void QOpenGLFunctions_1_5::glColorMaterial(GLenum face, GLenum mode)
{
    d_1_0_Deprecated->f.ColorMaterial(face, mode);
}

inline void QOpenGLFunctions_1_5::glClipPlane(GLenum plane, const GLdouble *equation)
{
    d_1_0_Deprecated->f.ClipPlane(plane, equation);
}

inline void QOpenGLFunctions_1_5::glVertex4sv(const GLshort *v)
{
    d_1_0_Deprecated->f.Vertex4sv(v);
}

inline void QOpenGLFunctions_1_5::glVertex4s(GLshort x, GLshort y, GLshort z, GLshort w)
{
    d_1_0_Deprecated->f.Vertex4s(x, y, z, w);
}

inline void QOpenGLFunctions_1_5::glVertex4iv(const GLint *v)
{
    d_1_0_Deprecated->f.Vertex4iv(v);
}

inline void QOpenGLFunctions_1_5::glVertex4i(GLint x, GLint y, GLint z, GLint w)
{
    d_1_0_Deprecated->f.Vertex4i(x, y, z, w);
}

inline void QOpenGLFunctions_1_5::glVertex4fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.Vertex4fv(v);
}

inline void QOpenGLFunctions_1_5::glVertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    d_1_0_Deprecated->f.Vertex4f(x, y, z, w);
}

inline void QOpenGLFunctions_1_5::glVertex4dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.Vertex4dv(v);
}

inline void QOpenGLFunctions_1_5::glVertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    d_1_0_Deprecated->f.Vertex4d(x, y, z, w);
}

inline void QOpenGLFunctions_1_5::glVertex3sv(const GLshort *v)
{
    d_1_0_Deprecated->f.Vertex3sv(v);
}

inline void QOpenGLFunctions_1_5::glVertex3s(GLshort x, GLshort y, GLshort z)
{
    d_1_0_Deprecated->f.Vertex3s(x, y, z);
}

inline void QOpenGLFunctions_1_5::glVertex3iv(const GLint *v)
{
    d_1_0_Deprecated->f.Vertex3iv(v);
}

inline void QOpenGLFunctions_1_5::glVertex3i(GLint x, GLint y, GLint z)
{
    d_1_0_Deprecated->f.Vertex3i(x, y, z);
}

inline void QOpenGLFunctions_1_5::glVertex3fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.Vertex3fv(v);
}

inline void QOpenGLFunctions_1_5::glVertex3f(GLfloat x, GLfloat y, GLfloat z)
{
    d_1_0_Deprecated->f.Vertex3f(x, y, z);
}

inline void QOpenGLFunctions_1_5::glVertex3dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.Vertex3dv(v);
}

inline void QOpenGLFunctions_1_5::glVertex3d(GLdouble x, GLdouble y, GLdouble z)
{
    d_1_0_Deprecated->f.Vertex3d(x, y, z);
}

inline void QOpenGLFunctions_1_5::glVertex2sv(const GLshort *v)
{
    d_1_0_Deprecated->f.Vertex2sv(v);
}

inline void QOpenGLFunctions_1_5::glVertex2s(GLshort x, GLshort y)
{
    d_1_0_Deprecated->f.Vertex2s(x, y);
}

inline void QOpenGLFunctions_1_5::glVertex2iv(const GLint *v)
{
    d_1_0_Deprecated->f.Vertex2iv(v);
}

inline void QOpenGLFunctions_1_5::glVertex2i(GLint x, GLint y)
{
    d_1_0_Deprecated->f.Vertex2i(x, y);
}

inline void QOpenGLFunctions_1_5::glVertex2fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.Vertex2fv(v);
}

inline void QOpenGLFunctions_1_5::glVertex2f(GLfloat x, GLfloat y)
{
    d_1_0_Deprecated->f.Vertex2f(x, y);
}

inline void QOpenGLFunctions_1_5::glVertex2dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.Vertex2dv(v);
}

inline void QOpenGLFunctions_1_5::glVertex2d(GLdouble x, GLdouble y)
{
    d_1_0_Deprecated->f.Vertex2d(x, y);
}

inline void QOpenGLFunctions_1_5::glTexCoord4sv(const GLshort *v)
{
    d_1_0_Deprecated->f.TexCoord4sv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q)
{
    d_1_0_Deprecated->f.TexCoord4s(s, t, r, q);
}

inline void QOpenGLFunctions_1_5::glTexCoord4iv(const GLint *v)
{
    d_1_0_Deprecated->f.TexCoord4iv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord4i(GLint s, GLint t, GLint r, GLint q)
{
    d_1_0_Deprecated->f.TexCoord4i(s, t, r, q);
}

inline void QOpenGLFunctions_1_5::glTexCoord4fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.TexCoord4fv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    d_1_0_Deprecated->f.TexCoord4f(s, t, r, q);
}

inline void QOpenGLFunctions_1_5::glTexCoord4dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.TexCoord4dv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
    d_1_0_Deprecated->f.TexCoord4d(s, t, r, q);
}

inline void QOpenGLFunctions_1_5::glTexCoord3sv(const GLshort *v)
{
    d_1_0_Deprecated->f.TexCoord3sv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord3s(GLshort s, GLshort t, GLshort r)
{
    d_1_0_Deprecated->f.TexCoord3s(s, t, r);
}

inline void QOpenGLFunctions_1_5::glTexCoord3iv(const GLint *v)
{
    d_1_0_Deprecated->f.TexCoord3iv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord3i(GLint s, GLint t, GLint r)
{
    d_1_0_Deprecated->f.TexCoord3i(s, t, r);
}

inline void QOpenGLFunctions_1_5::glTexCoord3fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.TexCoord3fv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord3f(GLfloat s, GLfloat t, GLfloat r)
{
    d_1_0_Deprecated->f.TexCoord3f(s, t, r);
}

inline void QOpenGLFunctions_1_5::glTexCoord3dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.TexCoord3dv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord3d(GLdouble s, GLdouble t, GLdouble r)
{
    d_1_0_Deprecated->f.TexCoord3d(s, t, r);
}

inline void QOpenGLFunctions_1_5::glTexCoord2sv(const GLshort *v)
{
    d_1_0_Deprecated->f.TexCoord2sv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord2s(GLshort s, GLshort t)
{
    d_1_0_Deprecated->f.TexCoord2s(s, t);
}

inline void QOpenGLFunctions_1_5::glTexCoord2iv(const GLint *v)
{
    d_1_0_Deprecated->f.TexCoord2iv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord2i(GLint s, GLint t)
{
    d_1_0_Deprecated->f.TexCoord2i(s, t);
}

inline void QOpenGLFunctions_1_5::glTexCoord2fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.TexCoord2fv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord2f(GLfloat s, GLfloat t)
{
    d_1_0_Deprecated->f.TexCoord2f(s, t);
}

inline void QOpenGLFunctions_1_5::glTexCoord2dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.TexCoord2dv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord2d(GLdouble s, GLdouble t)
{
    d_1_0_Deprecated->f.TexCoord2d(s, t);
}

inline void QOpenGLFunctions_1_5::glTexCoord1sv(const GLshort *v)
{
    d_1_0_Deprecated->f.TexCoord1sv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord1s(GLshort s)
{
    d_1_0_Deprecated->f.TexCoord1s(s);
}

inline void QOpenGLFunctions_1_5::glTexCoord1iv(const GLint *v)
{
    d_1_0_Deprecated->f.TexCoord1iv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord1i(GLint s)
{
    d_1_0_Deprecated->f.TexCoord1i(s);
}

inline void QOpenGLFunctions_1_5::glTexCoord1fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.TexCoord1fv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord1f(GLfloat s)
{
    d_1_0_Deprecated->f.TexCoord1f(s);
}

inline void QOpenGLFunctions_1_5::glTexCoord1dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.TexCoord1dv(v);
}

inline void QOpenGLFunctions_1_5::glTexCoord1d(GLdouble s)
{
    d_1_0_Deprecated->f.TexCoord1d(s);
}

inline void QOpenGLFunctions_1_5::glRectsv(const GLshort *v1, const GLshort *v2)
{
    d_1_0_Deprecated->f.Rectsv(v1, v2);
}

inline void QOpenGLFunctions_1_5::glRects(GLshort x1, GLshort y1, GLshort x2, GLshort y2)
{
    d_1_0_Deprecated->f.Rects(x1, y1, x2, y2);
}

inline void QOpenGLFunctions_1_5::glRectiv(const GLint *v1, const GLint *v2)
{
    d_1_0_Deprecated->f.Rectiv(v1, v2);
}

inline void QOpenGLFunctions_1_5::glRecti(GLint x1, GLint y1, GLint x2, GLint y2)
{
    d_1_0_Deprecated->f.Recti(x1, y1, x2, y2);
}

inline void QOpenGLFunctions_1_5::glRectfv(const GLfloat *v1, const GLfloat *v2)
{
    d_1_0_Deprecated->f.Rectfv(v1, v2);
}

inline void QOpenGLFunctions_1_5::glRectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2)
{
    d_1_0_Deprecated->f.Rectf(x1, y1, x2, y2);
}

inline void QOpenGLFunctions_1_5::glRectdv(const GLdouble *v1, const GLdouble *v2)
{
    d_1_0_Deprecated->f.Rectdv(v1, v2);
}

inline void QOpenGLFunctions_1_5::glRectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)
{
    d_1_0_Deprecated->f.Rectd(x1, y1, x2, y2);
}

inline void QOpenGLFunctions_1_5::glRasterPos4sv(const GLshort *v)
{
    d_1_0_Deprecated->f.RasterPos4sv(v);
}

inline void QOpenGLFunctions_1_5::glRasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w)
{
    d_1_0_Deprecated->f.RasterPos4s(x, y, z, w);
}

inline void QOpenGLFunctions_1_5::glRasterPos4iv(const GLint *v)
{
    d_1_0_Deprecated->f.RasterPos4iv(v);
}

inline void QOpenGLFunctions_1_5::glRasterPos4i(GLint x, GLint y, GLint z, GLint w)
{
    d_1_0_Deprecated->f.RasterPos4i(x, y, z, w);
}

inline void QOpenGLFunctions_1_5::glRasterPos4fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.RasterPos4fv(v);
}

inline void QOpenGLFunctions_1_5::glRasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    d_1_0_Deprecated->f.RasterPos4f(x, y, z, w);
}

inline void QOpenGLFunctions_1_5::glRasterPos4dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.RasterPos4dv(v);
}

inline void QOpenGLFunctions_1_5::glRasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    d_1_0_Deprecated->f.RasterPos4d(x, y, z, w);
}

inline void QOpenGLFunctions_1_5::glRasterPos3sv(const GLshort *v)
{
    d_1_0_Deprecated->f.RasterPos3sv(v);
}

inline void QOpenGLFunctions_1_5::glRasterPos3s(GLshort x, GLshort y, GLshort z)
{
    d_1_0_Deprecated->f.RasterPos3s(x, y, z);
}

inline void QOpenGLFunctions_1_5::glRasterPos3iv(const GLint *v)
{
    d_1_0_Deprecated->f.RasterPos3iv(v);
}

inline void QOpenGLFunctions_1_5::glRasterPos3i(GLint x, GLint y, GLint z)
{
    d_1_0_Deprecated->f.RasterPos3i(x, y, z);
}

inline void QOpenGLFunctions_1_5::glRasterPos3fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.RasterPos3fv(v);
}

inline void QOpenGLFunctions_1_5::glRasterPos3f(GLfloat x, GLfloat y, GLfloat z)
{
    d_1_0_Deprecated->f.RasterPos3f(x, y, z);
}

inline void QOpenGLFunctions_1_5::glRasterPos3dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.RasterPos3dv(v);
}

inline void QOpenGLFunctions_1_5::glRasterPos3d(GLdouble x, GLdouble y, GLdouble z)
{
    d_1_0_Deprecated->f.RasterPos3d(x, y, z);
}

inline void QOpenGLFunctions_1_5::glRasterPos2sv(const GLshort *v)
{
    d_1_0_Deprecated->f.RasterPos2sv(v);
}

inline void QOpenGLFunctions_1_5::glRasterPos2s(GLshort x, GLshort y)
{
    d_1_0_Deprecated->f.RasterPos2s(x, y);
}

inline void QOpenGLFunctions_1_5::glRasterPos2iv(const GLint *v)
{
    d_1_0_Deprecated->f.RasterPos2iv(v);
}

inline void QOpenGLFunctions_1_5::glRasterPos2i(GLint x, GLint y)
{
    d_1_0_Deprecated->f.RasterPos2i(x, y);
}

inline void QOpenGLFunctions_1_5::glRasterPos2fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.RasterPos2fv(v);
}

inline void QOpenGLFunctions_1_5::glRasterPos2f(GLfloat x, GLfloat y)
{
    d_1_0_Deprecated->f.RasterPos2f(x, y);
}

inline void QOpenGLFunctions_1_5::glRasterPos2dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.RasterPos2dv(v);
}

inline void QOpenGLFunctions_1_5::glRasterPos2d(GLdouble x, GLdouble y)
{
    d_1_0_Deprecated->f.RasterPos2d(x, y);
}

inline void QOpenGLFunctions_1_5::glNormal3sv(const GLshort *v)
{
    d_1_0_Deprecated->f.Normal3sv(v);
}

inline void QOpenGLFunctions_1_5::glNormal3s(GLshort nx, GLshort ny, GLshort nz)
{
    d_1_0_Deprecated->f.Normal3s(nx, ny, nz);
}

inline void QOpenGLFunctions_1_5::glNormal3iv(const GLint *v)
{
    d_1_0_Deprecated->f.Normal3iv(v);
}

inline void QOpenGLFunctions_1_5::glNormal3i(GLint nx, GLint ny, GLint nz)
{
    d_1_0_Deprecated->f.Normal3i(nx, ny, nz);
}

inline void QOpenGLFunctions_1_5::glNormal3fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.Normal3fv(v);
}

inline void QOpenGLFunctions_1_5::glNormal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
    d_1_0_Deprecated->f.Normal3f(nx, ny, nz);
}

inline void QOpenGLFunctions_1_5::glNormal3dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.Normal3dv(v);
}

inline void QOpenGLFunctions_1_5::glNormal3d(GLdouble nx, GLdouble ny, GLdouble nz)
{
    d_1_0_Deprecated->f.Normal3d(nx, ny, nz);
}

inline void QOpenGLFunctions_1_5::glNormal3bv(const GLbyte *v)
{
    d_1_0_Deprecated->f.Normal3bv(v);
}

inline void QOpenGLFunctions_1_5::glNormal3b(GLbyte nx, GLbyte ny, GLbyte nz)
{
    d_1_0_Deprecated->f.Normal3b(nx, ny, nz);
}

inline void QOpenGLFunctions_1_5::glIndexsv(const GLshort *c)
{
    d_1_0_Deprecated->f.Indexsv(c);
}

inline void QOpenGLFunctions_1_5::glIndexs(GLshort c)
{
    d_1_0_Deprecated->f.Indexs(c);
}

inline void QOpenGLFunctions_1_5::glIndexiv(const GLint *c)
{
    d_1_0_Deprecated->f.Indexiv(c);
}

inline void QOpenGLFunctions_1_5::glIndexi(GLint c)
{
    d_1_0_Deprecated->f.Indexi(c);
}

inline void QOpenGLFunctions_1_5::glIndexfv(const GLfloat *c)
{
    d_1_0_Deprecated->f.Indexfv(c);
}

inline void QOpenGLFunctions_1_5::glIndexf(GLfloat c)
{
    d_1_0_Deprecated->f.Indexf(c);
}

inline void QOpenGLFunctions_1_5::glIndexdv(const GLdouble *c)
{
    d_1_0_Deprecated->f.Indexdv(c);
}

inline void QOpenGLFunctions_1_5::glIndexd(GLdouble c)
{
    d_1_0_Deprecated->f.Indexd(c);
}

inline void QOpenGLFunctions_1_5::glEnd()
{
    d_1_0_Deprecated->f.End();
}

inline void QOpenGLFunctions_1_5::glEdgeFlagv(const GLboolean *flag)
{
    d_1_0_Deprecated->f.EdgeFlagv(flag);
}

inline void QOpenGLFunctions_1_5::glEdgeFlag(GLboolean flag)
{
    d_1_0_Deprecated->f.EdgeFlag(flag);
}

inline void QOpenGLFunctions_1_5::glColor4usv(const GLushort *v)
{
    d_1_0_Deprecated->f.Color4usv(v);
}

inline void QOpenGLFunctions_1_5::glColor4us(GLushort red, GLushort green, GLushort blue, GLushort alpha)
{
    d_1_0_Deprecated->f.Color4us(red, green, blue, alpha);
}

inline void QOpenGLFunctions_1_5::glColor4uiv(const GLuint *v)
{
    d_1_0_Deprecated->f.Color4uiv(v);
}

inline void QOpenGLFunctions_1_5::glColor4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
    d_1_0_Deprecated->f.Color4ui(red, green, blue, alpha);
}

inline void QOpenGLFunctions_1_5::glColor4ubv(const GLubyte *v)
{
    d_1_0_Deprecated->f.Color4ubv(v);
}

inline void QOpenGLFunctions_1_5::glColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    d_1_0_Deprecated->f.Color4ub(red, green, blue, alpha);
}

inline void QOpenGLFunctions_1_5::glColor4sv(const GLshort *v)
{
    d_1_0_Deprecated->f.Color4sv(v);
}

inline void QOpenGLFunctions_1_5::glColor4s(GLshort red, GLshort green, GLshort blue, GLshort alpha)
{
    d_1_0_Deprecated->f.Color4s(red, green, blue, alpha);
}

inline void QOpenGLFunctions_1_5::glColor4iv(const GLint *v)
{
    d_1_0_Deprecated->f.Color4iv(v);
}

inline void QOpenGLFunctions_1_5::glColor4i(GLint red, GLint green, GLint blue, GLint alpha)
{
    d_1_0_Deprecated->f.Color4i(red, green, blue, alpha);
}

inline void QOpenGLFunctions_1_5::glColor4fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.Color4fv(v);
}

inline void QOpenGLFunctions_1_5::glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    d_1_0_Deprecated->f.Color4f(red, green, blue, alpha);
}

inline void QOpenGLFunctions_1_5::glColor4dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.Color4dv(v);
}

inline void QOpenGLFunctions_1_5::glColor4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)
{
    d_1_0_Deprecated->f.Color4d(red, green, blue, alpha);
}

inline void QOpenGLFunctions_1_5::glColor4bv(const GLbyte *v)
{
    d_1_0_Deprecated->f.Color4bv(v);
}

inline void QOpenGLFunctions_1_5::glColor4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha)
{
    d_1_0_Deprecated->f.Color4b(red, green, blue, alpha);
}

inline void QOpenGLFunctions_1_5::glColor3usv(const GLushort *v)
{
    d_1_0_Deprecated->f.Color3usv(v);
}

inline void QOpenGLFunctions_1_5::glColor3us(GLushort red, GLushort green, GLushort blue)
{
    d_1_0_Deprecated->f.Color3us(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glColor3uiv(const GLuint *v)
{
    d_1_0_Deprecated->f.Color3uiv(v);
}

inline void QOpenGLFunctions_1_5::glColor3ui(GLuint red, GLuint green, GLuint blue)
{
    d_1_0_Deprecated->f.Color3ui(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glColor3ubv(const GLubyte *v)
{
    d_1_0_Deprecated->f.Color3ubv(v);
}

inline void QOpenGLFunctions_1_5::glColor3ub(GLubyte red, GLubyte green, GLubyte blue)
{
    d_1_0_Deprecated->f.Color3ub(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glColor3sv(const GLshort *v)
{
    d_1_0_Deprecated->f.Color3sv(v);
}

inline void QOpenGLFunctions_1_5::glColor3s(GLshort red, GLshort green, GLshort blue)
{
    d_1_0_Deprecated->f.Color3s(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glColor3iv(const GLint *v)
{
    d_1_0_Deprecated->f.Color3iv(v);
}

inline void QOpenGLFunctions_1_5::glColor3i(GLint red, GLint green, GLint blue)
{
    d_1_0_Deprecated->f.Color3i(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glColor3fv(const GLfloat *v)
{
    d_1_0_Deprecated->f.Color3fv(v);
}

inline void QOpenGLFunctions_1_5::glColor3f(GLfloat red, GLfloat green, GLfloat blue)
{
    d_1_0_Deprecated->f.Color3f(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glColor3dv(const GLdouble *v)
{
    d_1_0_Deprecated->f.Color3dv(v);
}

inline void QOpenGLFunctions_1_5::glColor3d(GLdouble red, GLdouble green, GLdouble blue)
{
    d_1_0_Deprecated->f.Color3d(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glColor3bv(const GLbyte *v)
{
    d_1_0_Deprecated->f.Color3bv(v);
}

inline void QOpenGLFunctions_1_5::glColor3b(GLbyte red, GLbyte green, GLbyte blue)
{
    d_1_0_Deprecated->f.Color3b(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glBitmap(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap)
{
    d_1_0_Deprecated->f.Bitmap(width, height, xorig, yorig, xmove, ymove, bitmap);
}

inline void QOpenGLFunctions_1_5::glBegin(GLenum mode)
{
    d_1_0_Deprecated->f.Begin(mode);
}

inline void QOpenGLFunctions_1_5::glListBase(GLuint base)
{
    d_1_0_Deprecated->f.ListBase(base);
}

inline GLuint QOpenGLFunctions_1_5::glGenLists(GLsizei range)
{
    return d_1_0_Deprecated->f.GenLists(range);
}

inline void QOpenGLFunctions_1_5::glDeleteLists(GLuint list, GLsizei range)
{
    d_1_0_Deprecated->f.DeleteLists(list, range);
}

inline void QOpenGLFunctions_1_5::glCallLists(GLsizei n, GLenum type, const GLvoid *lists)
{
    d_1_0_Deprecated->f.CallLists(n, type, lists);
}

inline void QOpenGLFunctions_1_5::glCallList(GLuint list)
{
    d_1_0_Deprecated->f.CallList(list);
}

inline void QOpenGLFunctions_1_5::glEndList()
{
    d_1_0_Deprecated->f.EndList();
}

inline void QOpenGLFunctions_1_5::glNewList(GLuint list, GLenum mode)
{
    d_1_0_Deprecated->f.NewList(list, mode);
}


// OpenGL 1.1 deprecated functions
inline void QOpenGLFunctions_1_5::glPushClientAttrib(GLbitfield mask)
{
    d_1_1_Deprecated->f.PushClientAttrib(mask);
}

inline void QOpenGLFunctions_1_5::glPopClientAttrib()
{
    d_1_1_Deprecated->f.PopClientAttrib();
}

inline void QOpenGLFunctions_1_5::glPrioritizeTextures(GLsizei n, const GLuint *textures, const GLfloat *priorities)
{
    d_1_1_Deprecated->f.PrioritizeTextures(n, textures, priorities);
}

inline GLboolean QOpenGLFunctions_1_5::glAreTexturesResident(GLsizei n, const GLuint *textures, GLboolean *residences)
{
    return d_1_1_Deprecated->f.AreTexturesResident(n, textures, residences);
}

inline void QOpenGLFunctions_1_5::glVertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    d_1_1_Deprecated->f.VertexPointer(size, type, stride, pointer);
}

inline void QOpenGLFunctions_1_5::glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    d_1_1_Deprecated->f.TexCoordPointer(size, type, stride, pointer);
}

inline void QOpenGLFunctions_1_5::glNormalPointer(GLenum type, GLsizei stride, const GLvoid *pointer)
{
    d_1_1_Deprecated->f.NormalPointer(type, stride, pointer);
}

inline void QOpenGLFunctions_1_5::glInterleavedArrays(GLenum format, GLsizei stride, const GLvoid *pointer)
{
    d_1_1_Deprecated->f.InterleavedArrays(format, stride, pointer);
}

inline void QOpenGLFunctions_1_5::glIndexPointer(GLenum type, GLsizei stride, const GLvoid *pointer)
{
    d_1_1_Deprecated->f.IndexPointer(type, stride, pointer);
}

inline void QOpenGLFunctions_1_5::glEnableClientState(GLenum array)
{
    d_1_1_Deprecated->f.EnableClientState(array);
}

inline void QOpenGLFunctions_1_5::glEdgeFlagPointer(GLsizei stride, const GLvoid *pointer)
{
    d_1_1_Deprecated->f.EdgeFlagPointer(stride, pointer);
}

inline void QOpenGLFunctions_1_5::glDisableClientState(GLenum array)
{
    d_1_1_Deprecated->f.DisableClientState(array);
}

inline void QOpenGLFunctions_1_5::glColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    d_1_1_Deprecated->f.ColorPointer(size, type, stride, pointer);
}

inline void QOpenGLFunctions_1_5::glArrayElement(GLint i)
{
    d_1_1_Deprecated->f.ArrayElement(i);
}


// OpenGL 1.2 deprecated functions
inline void QOpenGLFunctions_1_5::glResetMinmax(GLenum target)
{
    d_1_2_Deprecated->f.ResetMinmax(target);
}

inline void QOpenGLFunctions_1_5::glResetHistogram(GLenum target)
{
    d_1_2_Deprecated->f.ResetHistogram(target);
}

inline void QOpenGLFunctions_1_5::glMinmax(GLenum target, GLenum internalformat, GLboolean sink)
{
    d_1_2_Deprecated->f.Minmax(target, internalformat, sink);
}

inline void QOpenGLFunctions_1_5::glHistogram(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink)
{
    d_1_2_Deprecated->f.Histogram(target, width, internalformat, sink);
}

inline void QOpenGLFunctions_1_5::glGetMinmaxParameteriv(GLenum target, GLenum pname, GLint *params)
{
    d_1_2_Deprecated->f.GetMinmaxParameteriv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetMinmaxParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    d_1_2_Deprecated->f.GetMinmaxParameterfv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetMinmax(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values)
{
    d_1_2_Deprecated->f.GetMinmax(target, reset, format, type, values);
}

inline void QOpenGLFunctions_1_5::glGetHistogramParameteriv(GLenum target, GLenum pname, GLint *params)
{
    d_1_2_Deprecated->f.GetHistogramParameteriv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetHistogramParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    d_1_2_Deprecated->f.GetHistogramParameterfv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetHistogram(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values)
{
    d_1_2_Deprecated->f.GetHistogram(target, reset, format, type, values);
}

inline void QOpenGLFunctions_1_5::glSeparableFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column)
{
    d_1_2_Deprecated->f.SeparableFilter2D(target, internalformat, width, height, format, type, row, column);
}

inline void QOpenGLFunctions_1_5::glGetSeparableFilter(GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span)
{
    d_1_2_Deprecated->f.GetSeparableFilter(target, format, type, row, column, span);
}

inline void QOpenGLFunctions_1_5::glGetConvolutionParameteriv(GLenum target, GLenum pname, GLint *params)
{
    d_1_2_Deprecated->f.GetConvolutionParameteriv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetConvolutionParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    d_1_2_Deprecated->f.GetConvolutionParameterfv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetConvolutionFilter(GLenum target, GLenum format, GLenum type, GLvoid *image)
{
    d_1_2_Deprecated->f.GetConvolutionFilter(target, format, type, image);
}

inline void QOpenGLFunctions_1_5::glCopyConvolutionFilter2D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)
{
    d_1_2_Deprecated->f.CopyConvolutionFilter2D(target, internalformat, x, y, width, height);
}

inline void QOpenGLFunctions_1_5::glCopyConvolutionFilter1D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)
{
    d_1_2_Deprecated->f.CopyConvolutionFilter1D(target, internalformat, x, y, width);
}

inline void QOpenGLFunctions_1_5::glConvolutionParameteriv(GLenum target, GLenum pname, const GLint *params)
{
    d_1_2_Deprecated->f.ConvolutionParameteriv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glConvolutionParameteri(GLenum target, GLenum pname, GLint params)
{
    d_1_2_Deprecated->f.ConvolutionParameteri(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glConvolutionParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
    d_1_2_Deprecated->f.ConvolutionParameterfv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glConvolutionParameterf(GLenum target, GLenum pname, GLfloat params)
{
    d_1_2_Deprecated->f.ConvolutionParameterf(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glConvolutionFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image)
{
    d_1_2_Deprecated->f.ConvolutionFilter2D(target, internalformat, width, height, format, type, image);
}

inline void QOpenGLFunctions_1_5::glConvolutionFilter1D(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image)
{
    d_1_2_Deprecated->f.ConvolutionFilter1D(target, internalformat, width, format, type, image);
}

inline void QOpenGLFunctions_1_5::glCopyColorSubTable(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width)
{
    d_1_2_Deprecated->f.CopyColorSubTable(target, start, x, y, width);
}

inline void QOpenGLFunctions_1_5::glColorSubTable(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data)
{
    d_1_2_Deprecated->f.ColorSubTable(target, start, count, format, type, data);
}

inline void QOpenGLFunctions_1_5::glGetColorTableParameteriv(GLenum target, GLenum pname, GLint *params)
{
    d_1_2_Deprecated->f.GetColorTableParameteriv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetColorTableParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    d_1_2_Deprecated->f.GetColorTableParameterfv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glGetColorTable(GLenum target, GLenum format, GLenum type, GLvoid *table)
{
    d_1_2_Deprecated->f.GetColorTable(target, format, type, table);
}

inline void QOpenGLFunctions_1_5::glCopyColorTable(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)
{
    d_1_2_Deprecated->f.CopyColorTable(target, internalformat, x, y, width);
}

inline void QOpenGLFunctions_1_5::glColorTableParameteriv(GLenum target, GLenum pname, const GLint *params)
{
    d_1_2_Deprecated->f.ColorTableParameteriv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glColorTableParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
    d_1_2_Deprecated->f.ColorTableParameterfv(target, pname, params);
}

inline void QOpenGLFunctions_1_5::glColorTable(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table)
{
    d_1_2_Deprecated->f.ColorTable(target, internalformat, width, format, type, table);
}


// OpenGL 1.3 deprecated functions
inline void QOpenGLFunctions_1_5::glMultTransposeMatrixd(const GLdouble *m)
{
    d_1_3_Deprecated->f.MultTransposeMatrixd(m);
}

inline void QOpenGLFunctions_1_5::glMultTransposeMatrixf(const GLfloat *m)
{
    d_1_3_Deprecated->f.MultTransposeMatrixf(m);
}

inline void QOpenGLFunctions_1_5::glLoadTransposeMatrixd(const GLdouble *m)
{
    d_1_3_Deprecated->f.LoadTransposeMatrixd(m);
}

inline void QOpenGLFunctions_1_5::glLoadTransposeMatrixf(const GLfloat *m)
{
    d_1_3_Deprecated->f.LoadTransposeMatrixf(m);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord4sv(GLenum target, const GLshort *v)
{
    d_1_3_Deprecated->f.MultiTexCoord4sv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord4s(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q)
{
    d_1_3_Deprecated->f.MultiTexCoord4s(target, s, t, r, q);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord4iv(GLenum target, const GLint *v)
{
    d_1_3_Deprecated->f.MultiTexCoord4iv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord4i(GLenum target, GLint s, GLint t, GLint r, GLint q)
{
    d_1_3_Deprecated->f.MultiTexCoord4i(target, s, t, r, q);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord4fv(GLenum target, const GLfloat *v)
{
    d_1_3_Deprecated->f.MultiTexCoord4fv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    d_1_3_Deprecated->f.MultiTexCoord4f(target, s, t, r, q);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord4dv(GLenum target, const GLdouble *v)
{
    d_1_3_Deprecated->f.MultiTexCoord4dv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord4d(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
    d_1_3_Deprecated->f.MultiTexCoord4d(target, s, t, r, q);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord3sv(GLenum target, const GLshort *v)
{
    d_1_3_Deprecated->f.MultiTexCoord3sv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord3s(GLenum target, GLshort s, GLshort t, GLshort r)
{
    d_1_3_Deprecated->f.MultiTexCoord3s(target, s, t, r);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord3iv(GLenum target, const GLint *v)
{
    d_1_3_Deprecated->f.MultiTexCoord3iv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord3i(GLenum target, GLint s, GLint t, GLint r)
{
    d_1_3_Deprecated->f.MultiTexCoord3i(target, s, t, r);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord3fv(GLenum target, const GLfloat *v)
{
    d_1_3_Deprecated->f.MultiTexCoord3fv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord3f(GLenum target, GLfloat s, GLfloat t, GLfloat r)
{
    d_1_3_Deprecated->f.MultiTexCoord3f(target, s, t, r);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord3dv(GLenum target, const GLdouble *v)
{
    d_1_3_Deprecated->f.MultiTexCoord3dv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord3d(GLenum target, GLdouble s, GLdouble t, GLdouble r)
{
    d_1_3_Deprecated->f.MultiTexCoord3d(target, s, t, r);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord2sv(GLenum target, const GLshort *v)
{
    d_1_3_Deprecated->f.MultiTexCoord2sv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord2s(GLenum target, GLshort s, GLshort t)
{
    d_1_3_Deprecated->f.MultiTexCoord2s(target, s, t);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord2iv(GLenum target, const GLint *v)
{
    d_1_3_Deprecated->f.MultiTexCoord2iv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord2i(GLenum target, GLint s, GLint t)
{
    d_1_3_Deprecated->f.MultiTexCoord2i(target, s, t);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord2fv(GLenum target, const GLfloat *v)
{
    d_1_3_Deprecated->f.MultiTexCoord2fv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord2f(GLenum target, GLfloat s, GLfloat t)
{
    d_1_3_Deprecated->f.MultiTexCoord2f(target, s, t);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord2dv(GLenum target, const GLdouble *v)
{
    d_1_3_Deprecated->f.MultiTexCoord2dv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord2d(GLenum target, GLdouble s, GLdouble t)
{
    d_1_3_Deprecated->f.MultiTexCoord2d(target, s, t);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord1sv(GLenum target, const GLshort *v)
{
    d_1_3_Deprecated->f.MultiTexCoord1sv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord1s(GLenum target, GLshort s)
{
    d_1_3_Deprecated->f.MultiTexCoord1s(target, s);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord1iv(GLenum target, const GLint *v)
{
    d_1_3_Deprecated->f.MultiTexCoord1iv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord1i(GLenum target, GLint s)
{
    d_1_3_Deprecated->f.MultiTexCoord1i(target, s);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord1fv(GLenum target, const GLfloat *v)
{
    d_1_3_Deprecated->f.MultiTexCoord1fv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord1f(GLenum target, GLfloat s)
{
    d_1_3_Deprecated->f.MultiTexCoord1f(target, s);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord1dv(GLenum target, const GLdouble *v)
{
    d_1_3_Deprecated->f.MultiTexCoord1dv(target, v);
}

inline void QOpenGLFunctions_1_5::glMultiTexCoord1d(GLenum target, GLdouble s)
{
    d_1_3_Deprecated->f.MultiTexCoord1d(target, s);
}

inline void QOpenGLFunctions_1_5::glClientActiveTexture(GLenum texture)
{
    d_1_3_Deprecated->f.ClientActiveTexture(texture);
}


// OpenGL 1.4 deprecated functions
inline void QOpenGLFunctions_1_5::glWindowPos3sv(const GLshort *v)
{
    d_1_4_Deprecated->f.WindowPos3sv(v);
}

inline void QOpenGLFunctions_1_5::glWindowPos3s(GLshort x, GLshort y, GLshort z)
{
    d_1_4_Deprecated->f.WindowPos3s(x, y, z);
}

inline void QOpenGLFunctions_1_5::glWindowPos3iv(const GLint *v)
{
    d_1_4_Deprecated->f.WindowPos3iv(v);
}

inline void QOpenGLFunctions_1_5::glWindowPos3i(GLint x, GLint y, GLint z)
{
    d_1_4_Deprecated->f.WindowPos3i(x, y, z);
}

inline void QOpenGLFunctions_1_5::glWindowPos3fv(const GLfloat *v)
{
    d_1_4_Deprecated->f.WindowPos3fv(v);
}

inline void QOpenGLFunctions_1_5::glWindowPos3f(GLfloat x, GLfloat y, GLfloat z)
{
    d_1_4_Deprecated->f.WindowPos3f(x, y, z);
}

inline void QOpenGLFunctions_1_5::glWindowPos3dv(const GLdouble *v)
{
    d_1_4_Deprecated->f.WindowPos3dv(v);
}

inline void QOpenGLFunctions_1_5::glWindowPos3d(GLdouble x, GLdouble y, GLdouble z)
{
    d_1_4_Deprecated->f.WindowPos3d(x, y, z);
}

inline void QOpenGLFunctions_1_5::glWindowPos2sv(const GLshort *v)
{
    d_1_4_Deprecated->f.WindowPos2sv(v);
}

inline void QOpenGLFunctions_1_5::glWindowPos2s(GLshort x, GLshort y)
{
    d_1_4_Deprecated->f.WindowPos2s(x, y);
}

inline void QOpenGLFunctions_1_5::glWindowPos2iv(const GLint *v)
{
    d_1_4_Deprecated->f.WindowPos2iv(v);
}

inline void QOpenGLFunctions_1_5::glWindowPos2i(GLint x, GLint y)
{
    d_1_4_Deprecated->f.WindowPos2i(x, y);
}

inline void QOpenGLFunctions_1_5::glWindowPos2fv(const GLfloat *v)
{
    d_1_4_Deprecated->f.WindowPos2fv(v);
}

inline void QOpenGLFunctions_1_5::glWindowPos2f(GLfloat x, GLfloat y)
{
    d_1_4_Deprecated->f.WindowPos2f(x, y);
}

inline void QOpenGLFunctions_1_5::glWindowPos2dv(const GLdouble *v)
{
    d_1_4_Deprecated->f.WindowPos2dv(v);
}

inline void QOpenGLFunctions_1_5::glWindowPos2d(GLdouble x, GLdouble y)
{
    d_1_4_Deprecated->f.WindowPos2d(x, y);
}

inline void QOpenGLFunctions_1_5::glSecondaryColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    d_1_4_Deprecated->f.SecondaryColorPointer(size, type, stride, pointer);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3usv(const GLushort *v)
{
    d_1_4_Deprecated->f.SecondaryColor3usv(v);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3us(GLushort red, GLushort green, GLushort blue)
{
    d_1_4_Deprecated->f.SecondaryColor3us(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3uiv(const GLuint *v)
{
    d_1_4_Deprecated->f.SecondaryColor3uiv(v);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3ui(GLuint red, GLuint green, GLuint blue)
{
    d_1_4_Deprecated->f.SecondaryColor3ui(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3ubv(const GLubyte *v)
{
    d_1_4_Deprecated->f.SecondaryColor3ubv(v);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3ub(GLubyte red, GLubyte green, GLubyte blue)
{
    d_1_4_Deprecated->f.SecondaryColor3ub(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3sv(const GLshort *v)
{
    d_1_4_Deprecated->f.SecondaryColor3sv(v);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3s(GLshort red, GLshort green, GLshort blue)
{
    d_1_4_Deprecated->f.SecondaryColor3s(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3iv(const GLint *v)
{
    d_1_4_Deprecated->f.SecondaryColor3iv(v);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3i(GLint red, GLint green, GLint blue)
{
    d_1_4_Deprecated->f.SecondaryColor3i(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3fv(const GLfloat *v)
{
    d_1_4_Deprecated->f.SecondaryColor3fv(v);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3f(GLfloat red, GLfloat green, GLfloat blue)
{
    d_1_4_Deprecated->f.SecondaryColor3f(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3dv(const GLdouble *v)
{
    d_1_4_Deprecated->f.SecondaryColor3dv(v);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3d(GLdouble red, GLdouble green, GLdouble blue)
{
    d_1_4_Deprecated->f.SecondaryColor3d(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3bv(const GLbyte *v)
{
    d_1_4_Deprecated->f.SecondaryColor3bv(v);
}

inline void QOpenGLFunctions_1_5::glSecondaryColor3b(GLbyte red, GLbyte green, GLbyte blue)
{
    d_1_4_Deprecated->f.SecondaryColor3b(red, green, blue);
}

inline void QOpenGLFunctions_1_5::glFogCoordPointer(GLenum type, GLsizei stride, const GLvoid *pointer)
{
    d_1_4_Deprecated->f.FogCoordPointer(type, stride, pointer);
}

inline void QOpenGLFunctions_1_5::glFogCoorddv(const GLdouble *coord)
{
    d_1_4_Deprecated->f.FogCoorddv(coord);
}

inline void QOpenGLFunctions_1_5::glFogCoordd(GLdouble coord)
{
    d_1_4_Deprecated->f.FogCoordd(coord);
}

inline void QOpenGLFunctions_1_5::glFogCoordfv(const GLfloat *coord)
{
    d_1_4_Deprecated->f.FogCoordfv(coord);
}

inline void QOpenGLFunctions_1_5::glFogCoordf(GLfloat coord)
{
    d_1_4_Deprecated->f.FogCoordf(coord);
}


// OpenGL 1.5 deprecated functions


QT_END_NAMESPACE

#endif // QT_NO_OPENGL && !QT_CONFIG(opengles2)

#endif
