/****************************************************************************
**
** Copyright (C) 2020 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the tools applications of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#include "testtype.h"

/*!
    \module CrossModule
*/
/*!
    \class TestType
    \inmodule CrossModule
    \brief A class inheriting another class that lives in an external doc
           module.

    \section1 Linking

    These links go to the parent class:
    \list
      \li \l {TestQDoc::TestDerived}
      \li \l {TestQDoc::}{Test} class \l Usage.
      \li QDOCTEST_MACRO
    \endlist

    \section1 Generated Lists

    This is an annotated list of entries in a group:
    \annotatedlist testgroup

    \sa {TestQDoc::Test::}{someFunction()}
*/

/*!
    Nothing to see here.
*/
void TestType::nothing()
{
}
