/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the QtWaylandCompositor module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#define QT_WAYLANDCOMPOSITOR_BUILD_REMOVED_API

#include "qtwaylandcompositorglobal.h"

QT_USE_NAMESPACE

#if QT_WAYLANDCOMPOSITOR_REMOVED_SINCE(6, 3)

#include "qwaylandbufferref.h"

bool QWaylandBufferRef::operator==(const QWaylandBufferRef &other)
{
    return std::as_const(*this) == other;
}

bool QWaylandBufferRef::operator!=(const QWaylandBufferRef &other)
{
    return std::as_const(*this) != other;
}

#endif // QT_WAYLANDCOMPOSITOR_REMOVED_SINCE(6, 3)

#if QT_WAYLANDCOMPOSITOR_REMOVED_SINCE(6, 4)

// #include "qotherheader.h"
// // implement removed functions from qotherheader.h
// order alphabetically

#endif // QT_WAYLANDCOMPOSITOR_REMOVED_SINCE(6, 4)
